package com.xforceplus.ultraman.extensions.auth.plus.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

@ApiModel("用户中心列表")
@Data
public class UserCenterList<T> implements Serializable {

    @ApiModelProperty("当前页码")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private int number = 0;

    @ApiModelProperty("当页大小")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private int size = 0;

    @ApiModelProperty("总数")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private int totalElements = 0;

    @ApiModelProperty("返回结果")
    private List<T> content = Collections.emptyList();

    // Default constructor is not necessary as Lombok's @Data will generate one
}
