package com.xforceplus.ultraman.extensions.auth.plus.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel("用户中心基础返回")
@Data
public class UserCenterResponse<T> implements Serializable {

    private String code;
    private String message;

    @ApiModelProperty("")
    private T result;

    // Default constructor
    public UserCenterResponse() {
        this("", null, null);
    }

    public UserCenterResponse(String code, String message, T result) {
        this.code = code;
        this.message = message;
        this.result = result;
    }

    // Companion object equivalent
    public static final String FAIL_CODE = "0";
    public static final String SUCCESS_CODE = "1";
}

