package com.xforceplus.ultraman.extensions.auth.plus.util;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;

public class CommonHelper {

    public static <T, R> Predicate<? super T> distinctByKey(Function<? super T, R> transformer) {
        return t -> {
            Set<R> seen = ConcurrentHashMap.newKeySet();
            R apply = transformer.apply(t);
            return seen.add(apply);
        };
    }
}
