package com.xforceplus.ultraman.extensions.auth.plus.util.usercenter;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.xforceplus.tech.common.utils.JsonHelper;
import com.xforceplus.ultraman.extensions.auth.plus.model.LoginRequest;
import com.xforceplus.ultraman.extensions.auth.plus.model.LoginResponse;
import io.vavr.Tuple;
import io.vavr.Tuple3;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

import java.time.Duration;
import java.util.Optional;

@Slf4j
public class TokenTask {
    
    private final static String TOKEN_URL = "/client/login";
    
    private RestTemplate restTemplate;
    
    private LoadingCache<Tuple3<String, String, String>, String> tokenCache;
    
    public TokenTask(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
        this.tokenCache = Caffeine.newBuilder()
                .maximumSize(1)
                .refreshAfterWrite(Duration.ofSeconds(600))
                .build(tuple2-> getClientTokenInner(tuple2._1, tuple2._2(), tuple2._3));
    }
    
    private String getClientTokenInner(String url, String clientId, String secret) {
        LoginRequest request = new LoginRequest(clientId, secret);
        String retToken = null;
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "application/json");
        HttpEntity<LoginRequest> httpRequest = new HttpEntity<>(request, headers);
        try {
            ResponseEntity<LoginResponse> loginResponseResponseEntity = restTemplate.postForEntity(url.concat(TOKEN_URL), httpRequest, LoginResponse.class);
            LoginResponse body = loginResponseResponseEntity.getBody();
            if (body != null) {
                retToken = body.getData();
            }
        } catch (HttpStatusCodeException httpStatusCodeException) {
            log.error("scheduledGetToken HttpClientErrorException {}", httpStatusCodeException.getResponseBodyAsString());
            Optional<LoginResponse> loginResponse = JsonHelper.fromJsonStr(httpStatusCodeException.getResponseBodyAsString(), LoginResponse.class);
            if (loginResponse.isPresent()) {
                retToken = loginResponse.get().getData();
            }
        } catch (Throwable throwable) {
            log.error("scheduledGetToken exception", throwable);
            retToken = "";
        }

        return retToken;
    }

    public String getClientToken(String url, String clientId, String secret) {
        return tokenCache.get(Tuple.of(url, clientId, secret));
    }
}
