package com.xforceplus.ultraman.extensions.auth.ultraman;

import com.xforceplus.ultraman.datarule.core.provider.IDataRuleProvider;
import com.xforceplus.ultraman.datarule.domain.dto.RuleNodeDTO;
import com.xforceplus.ultraman.datarule.domain.dto.v2.EntityActionRoleRuleDTO;
import com.xforceplus.ultraman.datarule.domain.dto.v2.EntityActionRuleDetailDTO;
import com.xforceplus.ultraman.datarule.domain.enums.EntityActionType;
import com.xforceplus.ultraman.extensions.auth.utils.ExpFactoryEx;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.sdk.core.auth.AuthBuilder;
import com.xforceplus.ultraman.sdk.core.pipeline.OperationType;
import com.xforceplus.ultraman.sdk.core.pipeline.TransformerPipeline;
import com.xforceplus.ultraman.sdk.core.rel.legacy.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

@Slf4j
public class UltramanAuth implements AuthBuilder {

    @Autowired
    private IDataRuleProvider dataRuleProvider;

    @Autowired
    private TransformerPipeline transformerPipeline;
    
    @Autowired
    private ExternalRuleTransformer externalRuleTransformer;
    
    private EntityActionType toType(OperationType type) {
        switch (type) {
            case REPLACE:
            case UPDATE:
                return EntityActionType.UPDATE;
            case DELETE:
                return EntityActionType.DELETE;
            case CREATE:
                return EntityActionType.CREATE;
            case QUERY:
            default:
                return EntityActionType.READ;
        }
    }

    @Override
    public ExpRel getPermissionTreeCondition(Map<Long
            , Set<String>> involvedIdsMapping
            , ExpContext expContext, String profile, OperationType type) {
        try {
            Map<Long, EntityActionRuleDetailDTO> rules = new HashMap<>();
            rules = Optional.ofNullable(dataRuleProvider.currentUserDataRules(new ArrayList<>(involvedIdsMapping.keySet()), toType(type)))
                    .orElseGet(Collections::emptyMap);

            List<ExpNode> conditions = externalRuleTransformer.transform(expContext, rules, involvedIdsMapping);
            if (conditions.isEmpty()) {
                return null;
            }

            ExpQuery expQuery = new ExpQuery().filters(conditions);
            /**
             * will skip calcite and range restrict
             */
            ExpRel permissionExpRel = transformerPipeline.querySideHandleValue(expQuery
                    , expContext, Collections.singleton("calcite"), Collections.singleton("range"));
            return permissionExpRel;
        } catch (Throwable throwable) {
            return null;
        }
    }
}
