package com.xforceplus.ultraman.extensions.auth.plus;

import com.xforceplus.ultraman.extensions.auth.plus.model.MultiScaleUserCompanyData;
import com.xforceplus.ultraman.extensions.auth.plus.model.MultiScaleUserOrgData;
import com.xforceplus.ultraman.extensions.auth.plus.model.OrgDataForDataCompletion;
import com.xforceplus.ultraman.extensions.auth.plus.model.UserCenterResponse;

import java.util.List;

public interface UserCenterOrgJService {

    /**
     * 获取用户多层级组织id权限
     *
     * @param tenantId 租户id
     * @param userId   用户id
     * @return 用户多层级组织id权限
     */
    UserCenterResponse<MultiScaleUserOrgData> getUserMultiScaleOrgIdMap(Long tenantId, Long userId);

    /**
     * 获取用户多层级架构权限下的所有税号权限
     *
     * @param tenantId 租户id
     * @param userId   用户id
     * @return 用户有权限的全部税号
     */
    UserCenterResponse<List<MultiScaleUserCompanyData>> getUserMultiScaleCompanyList(Long tenantId, Long userId);

    /**
     * 根据公司id或组织代码或组织id补全组织信息
     *
     * @param tenantId  租户id
     * @param companyId 公司id
     * @param orgCode   组织代码
     * @param orgId     组织id
     * @return 组织信息
     */
    UserCenterResponse<OrgDataForDataCompletion> getOrgDataForDataCompletion(Long tenantId, Long companyId, String orgCode, Long orgId);

    /**
     * 获取用户组织权限的全部父级公司，包括直接上级和间接上级（一些搜索权限下的公司场景使用）
     *
     * @param tenantId 租户id
     * @param userId   用户id
     * @return 用户组织权限的全部父级公司
     */
    UserCenterResponse<List<MultiScaleUserCompanyData>> getUserOrgAllParentCompanies(Long tenantId, Long userId);

    /**
     * 获取用户组织权限的直接父级公司
     *
     * @param tenantId 租户id
     * @param userId   用户id
     * @return 用户组织权限的全部父级公司
     */
    UserCenterResponse<List<MultiScaleUserCompanyData>> getUserDirectParentCompanies(Long tenantId, Long userId);
    
    
}
