package com.xforceplus.ultraman.extensions.auth.plus.impl;

import com.google.common.collect.Maps;
import com.xforceplus.ultraman.extensions.auth.plus.*;
import com.xforceplus.ultraman.extensions.auth.plus.model.*;
import com.xforceplus.ultraman.extensions.auth.plus.util.RestTemplateHelper;
import com.xforceplus.ultraman.extensions.auth.plus.util.UserCenterJHelper;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.SmartInitializingSingleton;

import java.util.*;

@Slf4j
public class ClearAndInitDataServiceImpl implements ClearAndInitDataService, SmartInitializingSingleton {

    private String env;

    private final RestTemplateHelper restTemplateHelper;
//    private final RedissonHelper redissonHelper;

    private final UserCenterCacheService cacheService;
    
    private final UserCenterOrgJService userCenterOrgJService;
    
    private ExecutionConfig config;

    public ClearAndInitDataServiceImpl(String env, RestTemplateHelper restTemplateHelper
            , UserCenterCacheService cacheService
            , UserCenterOrgJService orgJService
            , ExecutionConfig executionConfig) {
        this.restTemplateHelper = restTemplateHelper;
        this.env = env;
        this.cacheService = cacheService;
        this.config = executionConfig;
        this.userCenterOrgJService = orgJService;
    }

//    private Iterator<RestOrgData> iterate(Long tenantId) {
//        int step = 1000;
//        return new LazyFetchIterator<>(Tuple.of(0, step), input -> {
//            log.debug("Current input {}", input);
//            final String subUrl = "/api/{tenantId}/v2/orgs?status=1";
//            String pageRowStr = String.format("&page=%s&row=%s", input._1, input._2);
//            UserCenterResponse<UserCenterList<RestOrgData>> fromPaas = restTemplateHelper.getFromPaas(env, subUrl + pageRowStr
//                    , new ParameterizedTypeReference<UserCenterResponse<UserCenterList<RestOrgData>>>() {
//                    },
//                    tenantId);
//            if (fromPaas.getCode().equals("1")) {
//                return fromPaas.getResult().getContent();
//            } else {
//                //how to handle when query is error?
//                return Collections.emptyList();
//            }
//        }, (input, last) -> {
//            return Tuple.of(input._1 + 1, step);
//        }, request -> true, response -> response.isEmpty() || response.size() < step, Function.identity());
//    }

    /**
     * () -> new LazyFetchIterator<>(initRel, expRel -> {
     *             log.debug("Current expRel {}", expRel);
     *             Either<QueryResult, DataCollection<Record>> queryResult = query(entityClass, expRel, context).toCompletableFuture().join();
     *
     *             if (queryResult.isRight()) {
     *                 return queryResult.get().getRows();
     *             } else {
     *                 //how to handle when query is error?
     *                 return Collections.emptyList();
     *             }
     *         }, (expRel, last) -> {
     *             return conditionTransformer.apply(expRel, last);
     *         }, request -> true, response -> response.isEmpty() || response.size() < step, transformer);
     */

    /**
     * 初始化租户下全部组织信息，供组织补全场景使用
     *
     * @param tenantId 租户id
     */
    @Override
    public void initTenantAllOrgDataCache(Long tenantId) {
        final UserCenterCacheKey userCenterCacheKey = UserCenterCacheKey.GET_ORG_DATA_FOR_DATA_COMPLETION;
        final String subUrl = "/{tenantId}/v2/orgs?status=1";
        UserCenterResponse<UserCenterList<RestOrgData>> iterate = restTemplateHelper.iterate(env, subUrl,1000, RestOrgData.class, tenantId);

        Optional.ofNullable(iterate.getResult())
                .map(UserCenterList::getContent)
                .orElseGet(Collections::emptyList).forEach(restOrgData -> {
                    final List<Long> parentIdList = UserCenterJHelper.splitParentIds(restOrgData.getParentIds());
                    final Map<Integer, Long> parentIdScaleMap = Maps.newLinkedHashMap();
                    for (int i = 1; i <= parentIdList.size(); i++) {
                        parentIdScaleMap.put(i, parentIdList.get(i - 1));
                    }

                    final OrgDataForDataCompletion orgDataForDataCompletion = new OrgDataForDataCompletion(
                            restOrgData.getOrgId(),
                            restOrgData.getOrgCode(),
                            parentIdScaleMap
                    );

                    UserCenterCache<Object> userCenterCache = cacheService.getUserCenterCache(userCenterCacheKey);
                    userCenterCache.trySetGroupByTenantId(tenantId, String.format(userCenterCacheKey.getPattern(), null, null, restOrgData.getOrgId()), orgDataForDataCompletion,true);
//                    if (restOrgData.getCompanyId() != null && restOrgData.getCompanyId() > 0L) {
//                        //根据公司id缓存
//                        //redissonHelper.trySetGroupByTenantId(userCenterCacheKey
//                        // , tenantId, String.format(userCenterCacheKey.getPattern(), restOrgData.getCompanyId(), null), orgDataForDataCompletion);
//                        userCenterCache.trySetGroupByTenantId(tenantId, String.format(userCenterCacheKey.getPattern(), restOrgData.getCompanyId(), null, null), orgDataForDataCompletion,true);
//                    } else if (StringUtils.isNotBlank(restOrgData.getOrgCode())) {
//                        //根据组织代码缓存
//                        userCenterCache.trySetGroupByTenantId(tenantId, String.format(userCenterCacheKey.getPattern(), null, restOrgData.getOrgCode(), null), orgDataForDataCompletion, true);
//                    }
                });
    }

    /**
     * 清除并重新初始化租户下全部组织信息，供组织补全场景使用
     *
     * @param tenantId 租户id
     */
    @Override
    public void clearAndReInitTenantAllOrgDataCache(final Long tenantId) {
        //redissonHelper.clearGroupByTenantId(UserCenterCacheKey.GET_ORG_DATA_FOR_DATA_COMPLETION, tenantId);
        final UserCenterCacheKey userCenterCacheKey = UserCenterCacheKey.GET_ORG_DATA_FOR_DATA_COMPLETION;
        UserCenterCache<OrgDataForDataCompletion> userCenterCache = cacheService.getUserCenterCache(userCenterCacheKey);
        userCenterCache.clearByTenantId(tenantId);
        this.initTenantAllOrgDataCache(tenantId);
    }

    @Override
    public void clearTenantOrgDataCache(final Long tenantId, final Long orgId, boolean reInit) {
        final UserCenterCacheKey userCenterCacheKey = UserCenterCacheKey.GET_ORG_DATA_FOR_DATA_COMPLETION;
        UserCenterCache<OrgDataForDataCompletion> userCenterCache = cacheService.getUserCenterCache(userCenterCacheKey);
        String currentKey = String.format(UserCenterCacheKey.GET_ORG_DATA_FOR_DATA_COMPLETION.getPattern(), null, null, orgId);
        userCenterCache.clearKeyGroupByTenantId(tenantId, currentKey);
        if(reInit) {
            userCenterOrgJService.getOrgDataForDataCompletion(tenantId, null, null, orgId);
        }
    }

    /**
     * 清除用户组织缓存
     *
     * @param tenantId 租户id
     * @param userId   用户id
     */
    @Override
    public void clearUserOrgCache(final Long tenantId, final Long userId) {
        //redissonHelper.clearKeyGroupByTenantId(UserCenterCacheKey.GET_USER_MULTI_SCALE_ORG_ID_MAP, tenantId, String.format(UserCenterCacheKey.GET_USER_MULTI_SCALE_ORG_ID_MAP.getPattern(), userId));
        //redissonHelper.clearKeyGroupByTenantId(UserCenterCacheKey.GET_USER_MULTI_SCALE_COMPANY_LIST, tenantId, String.format(UserCenterCacheKey.GET_USER_MULTI_SCALE_COMPANY_LIST.getPattern(), userId));
        //redissonHelper.clearKeyGroupByTenantId(UserCenterCacheKey.GET_USER_ORG_ALL_PARENT_COMPANIES, tenantId, String.format(UserCenterCacheKey.GET_USER_ORG_ALL_PARENT_COMPANIES.getPattern(), userId));
        //redissonHelper.clearKeyGroupByTenantId(UserCenterCacheKey.GET_USER_DIRECT_PARENT_COMPANIES, tenantId, String.format(UserCenterCacheKey.GET_USER_DIRECT_PARENT_COMPANIES.getPattern(), userId));

        final UserCenterCacheKey userCenterCacheKey = UserCenterCacheKey.GET_USER_MULTI_SCALE_ORG_ID_MAP;
        UserCenterCache<MultiScaleUserOrgData> userCenterCache = cacheService.getUserCenterCache(userCenterCacheKey);
        final String currentKey = String.format(userCenterCacheKey.getPattern(), userId);
        userCenterCache.clearKeyGroupByTenantId(tenantId, currentKey);
    }

    @Override
    public void afterSingletonsInstantiated() {
        Set<Long> orgTree = config.getOrgTree();
        for (Long tenantId : orgTree) {
            initTenantAllOrgDataCache(tenantId);  
        }
    }
}
