package com.xforceplus.ultraman.extensions.auth.plus.impl;

import com.xforceplus.ultraman.datarule.api.usercenter.orgtree.IUserCenterOrgTreeApi;
import com.xforceplus.ultraman.extensions.auth.plus.UserCenterOrgJService;
import com.xforceplus.ultraman.extensions.auth.plus.model.MultiScaleUserOrgData;
import com.xforceplus.ultraman.extensions.auth.plus.model.UserCenterResponse;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;


public class UserCenterOrgTreeApiImpl implements IUserCenterOrgTreeApi {

    private final UserCenterOrgJService userCenterOrgJService;

    public UserCenterOrgTreeApiImpl(UserCenterOrgJService userCenterOrgJService) {
        this.userCenterOrgJService = userCenterOrgJService;
    }

    @Override
    public List<String> getOrgIdTree(Long tenantId, Long userId) {
        UserCenterResponse<MultiScaleUserOrgData> response = userCenterOrgJService
                .getUserMultiScaleOrgIdMap(tenantId, userId);
        if (response != null) {
            MultiScaleUserOrgData result = response.getResult();
            if (result != null) {
                return result.getScaleMap().values().stream()
                        .flatMap(x -> x.stream().map(Object::toString))
                        .collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }
}
