package com.xforceplus.ultraman.extensions.auth.plus.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

@ApiModel("组织信息")
@Data
public class RestOrgData implements Serializable {

    @ApiModelProperty("组织id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long orgId = 0L;

    @ApiModelProperty("组织类型")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Integer orgType = 0;

    @ApiModelProperty("自定义类型")
    private String orgBizType = "";

    @ApiModelProperty("组织代码")
    private String orgCode = "";

    @ApiModelProperty("组织名称")
    private String orgName = "";

    @ApiModelProperty("公司id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long companyId = 0L;

    @ApiModelProperty("公司名称")
    private String companyName = "";

    @ApiModelProperty("公司代码")
    private String companyCode = "";

    @ApiModelProperty("公司编号集合")
    private List<String> companyNos = Collections.emptyList();

    @ApiModelProperty("税号")
    private String taxNum = "";

    @ApiModelProperty("租户id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long tenantId = 0L;

    @ApiModelProperty("租户名称")
    private String tenantName = "";

    @ApiModelProperty("租户代码")
    private String tenantCode = "";

    @ApiModelProperty("父级id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long parentId = 0L;

    @ApiModelProperty("是否是本租户的")
    private Boolean thisIsHost = true;

    @ApiModelProperty("父级id树")
    private String parentIds = "";

    // Default constructor is not necessary as Lombok's @Data will generate one
}
