package com.xforceplus.ultraman.extensions.auth.plus.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class TypeUtil {
    public static <T> Type getGenericType(Class<T> rawType, Type... typeArguments) {
        return new ParameterizedType() {
            @Override
            public Type[] getActualTypeArguments() {
                return typeArguments;
            }

            @Override
            public Type getRawType() {
                return rawType;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }

            @Override
            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append(rawType.getTypeName());
                if (typeArguments.length > 0) {
                    sb.append("<");
                    for (int i = 0; i < typeArguments.length; i++) {
                        if (i > 0) sb.append(", ");
                        sb.append(typeArguments[i].getTypeName());
                    }
                    sb.append(">");
                }
                return sb.toString();
            }
        };
    }
}