package com.xforceplus.ultraman.extensions.auth.plus.util;


import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.stream.Collectors;

public class UserCenterJHelper {

    /**
     * 按规则分拆parentIds字符串‘
     *
     * @param parentIdsStr 父节点id字符串
     * @return 父节点id列表
     */
    public static List<Long> splitParentIds(String parentIdsStr) {
        if (StringUtils.isBlank(parentIdsStr)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList(parentIdsStr.split("[#|/]"))
                .stream().filter(StringUtils::isNotBlank).map(Long::parseLong)
                .collect(Collectors.toList());
    }
}