package com.xforceplus.ultraman.extensions.auth.ultraman;

import com.xforceplus.ultraman.datarule.domain.dto.v2.EntityActionRuleDetailDTO;
import com.xforceplus.ultraman.extensions.auth.utils.ExpFactoryEx;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpCondition;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpContext;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpNode;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultRuleTransformer implements ExternalRuleTransformer {


    @Override
    public List<ExpNode> transform(ExpContext expContext, Map<Long, EntityActionRuleDetailDTO> rules, Map<Long, Set<String>> involvedIdsMapping) {
        List<ExpNode> conditions = new ArrayList<>();
        rules.forEach((k, v) -> {
            if (expContext.getSchema().getEntityClass().id() == k) {
                ExpCondition condition = ExpFactoryEx.createFromRuleNodeDTO(v.getRowRules(), null);
                conditions.add(condition);
            } else {
                Set<String> relationCodes = involvedIdsMapping.get(k);
                relationCodes.stream().forEach(x -> {
                    ExpCondition condition = ExpFactoryEx.createFromRuleNodeDTO(v.getRowRules(), x);
                    conditions.add(condition);
                });
            }
        });
        return conditions;
    }
}
