/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.auth.config;

import akka.actor.ActorSystem;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.datarule.api.usercenter.orgtree.IUserCenterOrgTreeApi;
import com.xforceplus.ultraman.extensions.auth.plus.ClearAndInitDataService;
import com.xforceplus.ultraman.extensions.auth.plus.UserCenterCacheService;
import com.xforceplus.ultraman.extensions.auth.plus.UserCenterOrgJService;
import com.xforceplus.ultraman.extensions.auth.plus.impl.ClearAndInitDataServiceImpl;
import com.xforceplus.ultraman.extensions.auth.plus.impl.DBCacheServiceImpl;
import com.xforceplus.ultraman.extensions.auth.plus.impl.UserCenterOrgJServiceImpl;
import com.xforceplus.ultraman.extensions.auth.plus.impl.UserCenterOrgTreeApiImpl;
import com.xforceplus.ultraman.extensions.auth.plus.pipeline.MultiOrgIdTransformer;
import com.xforceplus.ultraman.extensions.auth.plus.util.AuthTemplateProcessor;
import com.xforceplus.ultraman.extensions.auth.plus.util.RestTemplateHelper;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@AutoConfigureBefore(name={"com.xforceplus.ultraman.datarule.oqssdk.config.DataRuleApiAutoConfiguration"})
@Configuration
@ConditionalOnClass(name={"com.xforceplus.ultraman.datarule.api.usercenter.orgtree.IUserCenterOrgTreeApi"})
public class UltramanDataAuthPlusConfiguration {
    @Bean
    public AuthTemplateProcessor template(ObjectMapper mapper) {
        AuthTemplateProcessor template = new AuthTemplateProcessor(mapper);
        return template;
    }

    @Bean
    public UserCenterCacheService userCenterCacheService(@Qualifier(value="master") DataSource dataSource, ExecutionConfig exec, ActorSystem actorSystem) {
        DBCacheServiceImpl userCenterCacheService = new DBCacheServiceImpl(dataSource, actorSystem, exec);
        return userCenterCacheService;
    }

    @Bean
    public UserCenterOrgJService userCenterOrgJService(@Value(value="${ultraman.datarule.api.authTpls:usercenter:fat}") String tpls, UserCenterCacheService userCenterCacheService, RestTemplateHelper helper) {
        String env;
        try {
            env = StringUtils.isEmpty((CharSequence)tpls) ? "fat" : tpls.split(":")[1];
        }
        catch (Throwable ex) {
            env = "fat";
        }
        return new UserCenterOrgJServiceImpl(env, userCenterCacheService, helper);
    }

    @Bean
    public RestTemplateHelper restTemplateHelper(AuthTemplateProcessor template) {
        RestTemplateHelper restTemplateHelper = new RestTemplateHelper(new RestTemplate(), template);
        return restTemplateHelper;
    }

    @Bean
    public IUserCenterOrgTreeApi orgTreeApi(UserCenterOrgJService userCenterOrgJService) {
        return new UserCenterOrgTreeApiImpl(userCenterOrgJService);
    }

    @Bean
    public ClearAndInitDataService clearAndInitDataService(@Value(value="${ultraman.datarule.api.authTpls:usercenter:fat}") String tpls, RestTemplateHelper restTemplateHelper, UserCenterOrgJService userCenterOrgJService, UserCenterCacheService userCenterCacheService, ExecutionConfig executionConfig) {
        String env;
        try {
            env = StringUtils.isEmpty((CharSequence)tpls) ? "fat" : tpls.split(":")[1];
        }
        catch (Throwable ex) {
            env = "fat";
        }
        ClearAndInitDataServiceImpl clearAndInitDataService = new ClearAndInitDataServiceImpl(env, restTemplateHelper, userCenterCacheService, userCenterOrgJService, executionConfig);
        return clearAndInitDataService;
    }

    @Bean
    public MultiOrgIdTransformer multiOrgIdTransformer(UserCenterOrgJService userCenterOrgJService, ContextService contextService, ExecutionConfig executionConfig) {
        return new MultiOrgIdTransformer(userCenterOrgJService, contextService, executionConfig);
    }
}

