/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.auth.plus.impl;

import com.google.common.collect.Maps;
import com.xforceplus.ultraman.extensions.auth.plus.ClearAndInitDataService;
import com.xforceplus.ultraman.extensions.auth.plus.UserCenterCache;
import com.xforceplus.ultraman.extensions.auth.plus.UserCenterCacheKey;
import com.xforceplus.ultraman.extensions.auth.plus.UserCenterCacheService;
import com.xforceplus.ultraman.extensions.auth.plus.UserCenterOrgJService;
import com.xforceplus.ultraman.extensions.auth.plus.model.OrgDataForDataCompletion;
import com.xforceplus.ultraman.extensions.auth.plus.model.RestOrgData;
import com.xforceplus.ultraman.extensions.auth.plus.model.UserCenterList;
import com.xforceplus.ultraman.extensions.auth.plus.model.UserCenterResponse;
import com.xforceplus.ultraman.extensions.auth.plus.util.RestTemplateHelper;
import com.xforceplus.ultraman.extensions.auth.plus.util.UserCenterJHelper;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;

public class ClearAndInitDataServiceImpl
implements ClearAndInitDataService,
SmartInitializingSingleton {
    private static final Logger log = LoggerFactory.getLogger(ClearAndInitDataServiceImpl.class);
    private String env;
    private final RestTemplateHelper restTemplateHelper;
    private final UserCenterCacheService cacheService;
    private final UserCenterOrgJService userCenterOrgJService;
    private ExecutionConfig config;

    public ClearAndInitDataServiceImpl(String env, RestTemplateHelper restTemplateHelper, UserCenterCacheService cacheService, UserCenterOrgJService orgJService, ExecutionConfig executionConfig) {
        this.restTemplateHelper = restTemplateHelper;
        this.env = env;
        this.cacheService = cacheService;
        this.config = executionConfig;
        this.userCenterOrgJService = orgJService;
    }

    @Override
    public void initTenantAllOrgDataCache(Long tenantId) {
        UserCenterCacheKey userCenterCacheKey = UserCenterCacheKey.GET_ORG_DATA_FOR_DATA_COMPLETION;
        String subUrl = "/{tenantId}/v2/orgs?status=1";
        UserCenterResponse<UserCenterList<RestOrgData>> iterate = this.restTemplateHelper.iterate(this.env, "/{tenantId}/v2/orgs?status=1", 1000, RestOrgData.class, tenantId);
        Optional.ofNullable(iterate.getResult()).map(UserCenterList::getContent).orElseGet(Collections::emptyList).forEach(restOrgData -> {
            List<Long> parentIdList = UserCenterJHelper.splitParentIds(restOrgData.getParentIds());
            LinkedHashMap parentIdScaleMap = Maps.newLinkedHashMap();
            for (int i = 1; i <= parentIdList.size(); ++i) {
                parentIdScaleMap.put(i, parentIdList.get(i - 1));
            }
            OrgDataForDataCompletion orgDataForDataCompletion = new OrgDataForDataCompletion(restOrgData.getOrgId(), restOrgData.getOrgCode(), parentIdScaleMap);
            UserCenterCache<OrgDataForDataCompletion> userCenterCache = this.cacheService.getUserCenterCache(userCenterCacheKey);
            userCenterCache.trySetGroupByTenantId(tenantId, String.format(userCenterCacheKey.getPattern(), null, null, restOrgData.getOrgId()), orgDataForDataCompletion, true);
        });
    }

    @Override
    public void clearAndReInitTenantAllOrgDataCache(Long tenantId) {
        UserCenterCacheKey userCenterCacheKey = UserCenterCacheKey.GET_ORG_DATA_FOR_DATA_COMPLETION;
        UserCenterCache userCenterCache = this.cacheService.getUserCenterCache(userCenterCacheKey);
        userCenterCache.clearByTenantId(tenantId);
        this.initTenantAllOrgDataCache(tenantId);
    }

    @Override
    public void clearTenantOrgDataCache(Long tenantId, Long orgId, boolean reInit) {
        UserCenterCacheKey userCenterCacheKey = UserCenterCacheKey.GET_ORG_DATA_FOR_DATA_COMPLETION;
        UserCenterCache userCenterCache = this.cacheService.getUserCenterCache(userCenterCacheKey);
        String currentKey = String.format(UserCenterCacheKey.GET_ORG_DATA_FOR_DATA_COMPLETION.getPattern(), null, null, orgId);
        userCenterCache.clearKeyGroupByTenantId(tenantId, currentKey);
        if (reInit) {
            this.userCenterOrgJService.getOrgDataForDataCompletion(tenantId, null, null, orgId);
        }
    }

    @Override
    public void clearUserOrgCache(Long tenantId, Long userId) {
        UserCenterCacheKey userCenterCacheKey = UserCenterCacheKey.GET_USER_MULTI_SCALE_ORG_ID_MAP;
        UserCenterCache userCenterCache = this.cacheService.getUserCenterCache(userCenterCacheKey);
        String currentKey = String.format(userCenterCacheKey.getPattern(), userId);
        userCenterCache.clearKeyGroupByTenantId(tenantId, currentKey);
    }

    public void afterSingletonsInstantiated() {
        Set orgTree = this.config.getOrgTree();
        for (Long tenantId : orgTree) {
            this.initTenantAllOrgDataCache(tenantId);
        }
    }
}

