/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.auth.plus.impl;

import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.stream.ActorMaterializer;
import com.xforceplus.tech.common.utils.JsonHelper;
import com.xforceplus.ultraman.extensions.auth.plus.UserCenterCache;
import com.xforceplus.ultraman.extensions.auth.plus.UserCenterCacheKey;
import com.xforceplus.ultraman.extensions.auth.plus.UserCenterCacheService;
import com.xforceplus.ultraman.extensions.auth.plus.WriteTask;
import com.xforceplus.ultraman.extensions.auth.plus.impl.DBUserCenterCacheImpl;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;

public class DBCacheServiceImpl
implements UserCenterCacheService {
    private Map<UserCenterCacheKey, UserCenterCache<?>> cacheMapping = new ConcurrentHashMap();
    private String QUERY_SQL = "SELECT * from db_cache WHERE cate = ? and cache_key = ? and tenant_id = ?";
    private String UPDATE_SQL = "INSERT INTO db_cache(cate, cache_key, tenant_id, body) values (?,?,?,?) ON DUPLICATE KEY UPDATE body = values(body)";
    private String DELETE_SQL = "DELETE FROM db_cache where cate = ? and cache_key = ? and tenant_id = ? ";
    private String DELETE_SQL_TENANT_ID = "DELETE FROM db_cache where cate = ? and tenant_id = ?";
    private final JdbcTemplate jdbcTemplate;
    private final ExecutionConfig executionConfig;
    private ActorMaterializer mat;

    public DBCacheServiceImpl(@Qualifier(value="master") DataSource dataSource, ActorSystem actorSystem, ExecutionConfig executionConfig) {
        ActorMaterializer materializer;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.mat = materializer = ActorMaterializer.create((ActorRefFactory)actorSystem);
        this.executionConfig = executionConfig;
    }

    @Override
    public <T> UserCenterCache<T> getUserCenterCache(UserCenterCacheKey userCenterCacheKey) {
        UserCenterCache<?> userCenterCache = this.cacheMapping.get((Object)userCenterCacheKey);
        if (userCenterCache == null) {
            DBUserCenterCacheImpl cache = new DBUserCenterCacheImpl(this.mat, userCenterCacheKey, this, userCenterCacheKey.getClazz(), userCenterCacheKey.isList(), this.executionConfig.getOrgTreeCache());
            this.cacheMapping.put(userCenterCacheKey, cache);
            return cache;
        }
        return userCenterCache;
    }

    @Override
    public void writeToDbBatch(final List<WriteTask> list) {
        int[] ret = this.jdbcTemplate.batchUpdate(this.UPDATE_SQL, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                WriteTask writeTask = (WriteTask)list.get(i);
                ps.setString(1, writeTask.getCate());
                ps.setString(2, writeTask.getCacheKey());
                ps.setLong(3, writeTask.getTenantId());
                ps.setString(4, writeTask.getPayload());
            }

            public int getBatchSize() {
                return list.size();
            }
        });
    }

    public void writeToDb(String cate, Long tenantId, String currentKey, String body) {
        this.jdbcTemplate.update(this.UPDATE_SQL, pss -> {
            pss.setString(1, cate);
            pss.setString(2, currentKey);
            pss.setLong(3, tenantId);
            pss.setString(4, body);
        });
    }

    public <T> T readFromDb(String cate, Long tenantId, String currentKey, Class<T> clazz) {
        List listBody = this.jdbcTemplate.query(this.QUERY_SQL, (rs, row) -> {
            String body = rs.getString("body");
            return JsonHelper.fromJsonStr((String)body, (Class)clazz).orElse(null);
        }, new Object[]{cate, currentKey, tenantId});
        if (listBody.isEmpty()) {
            return null;
        }
        return (T)listBody.get(0);
    }

    public <T> List<T> readListFromDb(String cate, Long tenantId, String currentKey, Class<T> clazz) {
        List listBody = this.jdbcTemplate.query(this.QUERY_SQL, (rs, row) -> {
            String body = rs.getString("body");
            return JsonHelper.arrFromJsonStr((String)body, (Class)clazz).orElse(null);
        }, new Object[]{cate, currentKey, tenantId});
        if (listBody.isEmpty()) {
            return null;
        }
        return (List)listBody.get(0);
    }

    @Override
    public void deleteCache(String cate, Long tenantId, String currentKey) {
        this.jdbcTemplate.update(this.DELETE_SQL, pss -> {
            pss.setString(1, cate);
            pss.setString(2, currentKey);
            pss.setLong(3, tenantId);
        });
    }

    @Override
    public void deleteCacheByTenantId(String cate, Long tenantId) {
        this.jdbcTemplate.update(this.DELETE_SQL_TENANT_ID, pss -> {
            pss.setString(1, cate);
            pss.setLong(2, tenantId);
        });
    }
}

