/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.auth.plus.impl;

import akka.japi.function.Function;
import akka.stream.ActorMaterializer;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.OverflowStrategy;
import akka.stream.javadsl.Sink;
import akka.stream.javadsl.Source;
import akka.stream.javadsl.SourceQueueWithComplete;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.xforceplus.tech.common.utils.JsonHelper;
import com.xforceplus.ultraman.extensions.auth.plus.UserCenterCache;
import com.xforceplus.ultraman.extensions.auth.plus.UserCenterCacheKey;
import com.xforceplus.ultraman.extensions.auth.plus.WriteTask;
import com.xforceplus.ultraman.extensions.auth.plus.impl.DBCacheServiceImpl;
import com.xforceplus.ultraman.sdk.infra.utils.ThreadFactoryHelper;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBUserCenterCacheImpl<T>
implements UserCenterCache<T> {
    private static final Logger log = LoggerFactory.getLogger(DBUserCenterCacheImpl.class);
    private final DBCacheServiceImpl dbCacheService;
    private LoadingCache<Tuple2<Long, String>, Object> loadingCache;
    private final Class<T> clazz;
    private final boolean isList;
    private final UserCenterCacheKey userCenterCacheKey;
    private SourceQueueWithComplete<WriteTask> asyncTaskEngine;
    private ExecutorService executorService;
    private int timeout;
    private ActorMaterializer mat;

    public DBUserCenterCacheImpl(ActorMaterializer mat, UserCenterCacheKey userCenterCacheKey, DBCacheServiceImpl dbCacheService, Class<T> clazz, boolean isList, int timeout) {
        this.dbCacheService = dbCacheService;
        this.clazz = clazz;
        this.isList = isList;
        this.userCenterCacheKey = userCenterCacheKey;
        this.executorService = ThreadFactoryHelper.buildThreadPool((int)10, (int)10, (String)"db-sync", (boolean)false);
        this.mat = mat;
        this.loadingCache = Caffeine.newBuilder().maximumSize(50000L).refreshAfterWrite(Duration.ofSeconds(timeout)).build(key -> {
            log.info("Loading with {}", key);
            if (isList) {
                return dbCacheService.readListFromDb(userCenterCacheKey.getValue(), (Long)key._1, (String)key._2, clazz);
            }
            return dbCacheService.readFromDb(userCenterCacheKey.getValue(), (Long)key._1, (String)key._2, clazz);
        });
        this.asyncTaskEngine = (SourceQueueWithComplete)Source.queue((int)50000, (OverflowStrategy)OverflowStrategy.backpressure()).groupedWithin(1000, Duration.ofSeconds(10L)).mapAsync(10, (Function & Serializable)list -> CompletableFuture.supplyAsync(() -> {
            dbCacheService.writeToDbBatch((List<WriteTask>)list);
            return 1;
        }, this.executorService)).to((Graph)Sink.ignore()).run((Materializer)this.mat);
    }

    @Override
    public T getGroupByTenantId(Long tenantId, String currentKey) {
        if (!this.isList) {
            return (T)this.loadingCache.get((Object)Tuple.of((Object)tenantId, (Object)currentKey));
        }
        throw new RuntimeException("Cannot get Singleton from List");
    }

    @Override
    public List<T> getGroupByTenantIdInList(Long tenantId, String currentKey) {
        if (this.isList) {
            return (List)this.loadingCache.get((Object)Tuple.of((Object)tenantId, (Object)currentKey));
        }
        throw new RuntimeException("Cannot get List from singleton");
    }

    @Override
    public void trySetGroupByTenantId(Long tenantId, String currentKey, T payload) {
        this.trySetGroupByTenantId(tenantId, currentKey, payload, false);
    }

    @Override
    public void trySetGroupByTenantId(Long tenantId, String currentKey, T payload, boolean writeThrough) {
        this.loadingCache.put((Object)Tuple.of((Object)tenantId, (Object)currentKey), payload);
        if (writeThrough) {
            this.asyncTaskEngine.offer((Object)new WriteTask(this.userCenterCacheKey.getValue(), currentKey, tenantId, JsonHelper.toJsonStr(payload)));
        }
    }

    @Override
    public void clearKeyGroupByTenantId(Long tenantId, String currentKey) {
        this.loadingCache.invalidate((Object)Tuple.of((Object)tenantId, (Object)currentKey));
        this.dbCacheService.deleteCache(this.userCenterCacheKey.getValue(), tenantId, currentKey);
    }

    @Override
    public void clearByTenantId(Long tenantId) {
        ArrayList keySet = new ArrayList();
        this.loadingCache.asMap().forEach((k, v) -> {
            if (((Long)k._1()).equals(tenantId)) {
                keySet.add(k);
            }
        });
        this.loadingCache.invalidateAll(keySet);
        this.dbCacheService.deleteCacheByTenantId(this.userCenterCacheKey.getValue(), tenantId);
    }
}

