/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.auth.plus.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xforceplus.ultraman.extensions.auth.plus.UserCenterCache;
import com.xforceplus.ultraman.extensions.auth.plus.UserCenterCacheKey;
import com.xforceplus.ultraman.extensions.auth.plus.UserCenterCacheService;
import com.xforceplus.ultraman.extensions.auth.plus.UserCenterOrgJService;
import com.xforceplus.ultraman.extensions.auth.plus.model.MultiScaleUserCompanyData;
import com.xforceplus.ultraman.extensions.auth.plus.model.MultiScaleUserOrgData;
import com.xforceplus.ultraman.extensions.auth.plus.model.OrgDataForDataCompletion;
import com.xforceplus.ultraman.extensions.auth.plus.model.OrgDataForMultiScale;
import com.xforceplus.ultraman.extensions.auth.plus.model.RestOrgData;
import com.xforceplus.ultraman.extensions.auth.plus.model.UserCenterList;
import com.xforceplus.ultraman.extensions.auth.plus.model.UserCenterResponse;
import com.xforceplus.ultraman.extensions.auth.plus.util.CommonHelper;
import com.xforceplus.ultraman.extensions.auth.plus.util.RestTemplateHelper;
import com.xforceplus.ultraman.extensions.auth.plus.util.UserCenterJHelper;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCenterOrgJServiceImpl
implements UserCenterOrgJService {
    private static final Logger log = LoggerFactory.getLogger(UserCenterOrgJServiceImpl.class);
    private final UserCenterCacheService cacheService;
    private final RestTemplateHelper restTemplateHelper;
    private String env;

    public UserCenterOrgJServiceImpl(String env, UserCenterCacheService cacheService, RestTemplateHelper restTemplateHelper) {
        this.cacheService = cacheService;
        this.restTemplateHelper = restTemplateHelper;
        this.env = env;
    }

    @Override
    public UserCenterResponse<MultiScaleUserOrgData> getUserMultiScaleOrgIdMap(Long tenantId, Long userId) {
        UserCenterCacheKey userCenterCacheKey = UserCenterCacheKey.GET_USER_MULTI_SCALE_ORG_ID_MAP;
        String currentKey = String.format(userCenterCacheKey.getPattern(), userId);
        UserCenterCache<MultiScaleUserOrgData> scaleUserCache = this.cacheService.getUserCenterCache(userCenterCacheKey);
        MultiScaleUserOrgData cacheValue = (MultiScaleUserOrgData)scaleUserCache.getGroupByTenantId(tenantId, currentKey);
        if (cacheValue != null) {
            log.info("Success Got Cache within GetUserMultiScaleOrgIdMap");
            return new UserCenterResponse<MultiScaleUserOrgData>("1", "\u6210\u529f", cacheValue);
        }
        String subUrl = "/{tenantId}/v2/orgs?userId={userId}&status=1";
        UserCenterResponse<UserCenterList<OrgDataForMultiScale>> response = this.restTemplateHelper.iterate(this.env, "/{tenantId}/v2/orgs?userId={userId}&status=1", 1000, OrgDataForMultiScale.class, tenantId, userId);
        if (!"1".equals(response.getCode()) || response.getResult() == null || response.getResult().getContent() == null || response.getResult().getContent().isEmpty()) {
            return new UserCenterResponse<Object>(response.getCode(), response.getMessage(), null);
        }
        Map<Integer, List<Tuple2>> groupByParentIdsSize = response.getResult().getContent().stream().map(OrgDataForMultiScale::getParentIds).filter(StringUtils::isNotBlank).map(r -> Tuple.of(UserCenterJHelper.splitParentIds(r), (Object)r)).collect(Collectors.groupingBy(r -> ((List)r._1()).size()));
        Set<Integer> keySet = groupByParentIdsSize.keySet();
        Iterator iterator = groupByParentIdsSize.entrySet().stream().sorted(Map.Entry.comparingByKey()).iterator();
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            List filteredKeys = keySet.stream().filter(k -> k > (Integer)next.getKey()).collect(Collectors.toList());
            ((List)next.getValue()).forEach(v -> filteredKeys.forEach(key -> ((List)groupByParentIdsSize.getOrDefault(key, Lists.newArrayList())).removeIf(s -> ((String)s._2()).startsWith((String)v._2()))));
        }
        Map<Integer, List<Long>> map = groupByParentIdsSize.entrySet().stream().filter(r -> CollectionUtils.isNotEmpty((Collection)((Collection)r.getValue()))).collect(Collectors.toMap(x -> (Integer)x.getKey(), y -> ((List)y.getValue()).stream().map(t -> (Long)((List)t._1()).get(((List)t._1()).size() - 1)).collect(Collectors.toList())));
        MultiScaleUserOrgData multiScaleUserOrgData = new MultiScaleUserOrgData(map);
        scaleUserCache.trySetGroupByTenantId(tenantId, currentKey, multiScaleUserOrgData, true);
        return new UserCenterResponse<MultiScaleUserOrgData>(response.getCode(), response.getMessage(), multiScaleUserOrgData);
    }

    @Override
    public UserCenterResponse<List<MultiScaleUserCompanyData>> getUserMultiScaleCompanyList(Long tenantId, Long userId) {
        UserCenterCacheKey userCenterCacheKey = UserCenterCacheKey.GET_USER_MULTI_SCALE_COMPANY_LIST;
        String currentKey = String.format(userCenterCacheKey.getPattern(), userId);
        UserCenterCache cache = this.cacheService.getUserCenterCache(userCenterCacheKey);
        List cacheValue = (List)cache.getGroupByTenantId(tenantId, currentKey);
        if (cacheValue != null) {
            return new UserCenterResponse<List<MultiScaleUserCompanyData>>("1", "\u6210\u529f", cacheValue);
        }
        String subUrl = "/{tenantId}/v2/orgs?userId={userId}&status=1";
        UserCenterResponse<UserCenterList<OrgDataForMultiScale>> response = this.restTemplateHelper.iterate(this.env, "/{tenantId}/v2/orgs?userId={userId}&status=1", 1000, OrgDataForMultiScale.class, tenantId, userId);
        if (!"1".equals(response.getCode()) || response.getResult() == null || CollectionUtils.isEmpty(response.getResult().getContent())) {
            return new UserCenterResponse<Object>(response.getCode(), response.getMessage(), null);
        }
        List taxNoList = response.getResult().getContent().stream().filter(r -> r.getOrgType() == 1).map(r -> new MultiScaleUserCompanyData(r.getCompanyId(), r.getTaxNum(), r.getCompanyName())).distinct().collect(Collectors.toList());
        cache.trySetGroupByTenantId(tenantId, currentKey, taxNoList);
        return new UserCenterResponse<List<MultiScaleUserCompanyData>>(response.getCode(), response.getMessage(), taxNoList);
    }

    @Override
    public UserCenterResponse<OrgDataForDataCompletion> getOrgDataForDataCompletion(Long tenantId, Long companyId, String orgCode, Long orgId) {
        String subUrl;
        UserCenterResponse<UserCenterList<RestOrgData>> response;
        if ((Objects.isNull(companyId) || companyId <= 0L) && StringUtils.isBlank((CharSequence)orgCode) && (Objects.isNull(orgId) || orgId <= 0L)) {
            return new UserCenterResponse<Object>("0", "\u516c\u53f8id\u6216\u7ec4\u7ec7\u4ee3\u7801\u6216\u7ec4\u7ec7id\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", null);
        }
        UserCenterCacheKey userCenterCacheKey = UserCenterCacheKey.GET_ORG_DATA_FOR_DATA_COMPLETION;
        String currentKey = String.format(userCenterCacheKey.getPattern(), companyId, orgCode, orgId);
        UserCenterCache<OrgDataForDataCompletion> cache = this.cacheService.getUserCenterCache(userCenterCacheKey);
        OrgDataForDataCompletion cacheValue = (OrgDataForDataCompletion)cache.getGroupByTenantId(tenantId, currentKey);
        if (cacheValue != null) {
            log.info("Success Got Cache within OrgDataForDataCompletion");
            return new UserCenterResponse<OrgDataForDataCompletion>("1", "\u6210\u529f", cacheValue);
        }
        String subTempUrl = "/{tenantId}/v2/orgs?status=1";
        if (Objects.nonNull(companyId) && companyId > 0L) {
            subTempUrl = subTempUrl + "&companyId=" + companyId;
        }
        if (StringUtils.isNotBlank((CharSequence)orgCode)) {
            subTempUrl = subTempUrl + "&orgCode=" + orgCode;
        }
        if (Objects.nonNull(orgId) && orgId > 0L) {
            subTempUrl = subTempUrl + "&orgId=" + orgId;
        }
        if (!"1".equals((response = this.restTemplateHelper.iterate(this.env, subUrl = subTempUrl, 10, RestOrgData.class, tenantId)).getCode()) || response.getResult() == null || CollectionUtils.isEmpty(response.getResult().getContent())) {
            return new UserCenterResponse<Object>(response.getCode(), response.getMessage(), null);
        }
        RestOrgData restOrgData = response.getResult().getContent().get(0);
        List<Long> parentIdList = UserCenterJHelper.splitParentIds(restOrgData.getParentIds());
        LinkedHashMap<Integer, Long> parentIdScaleMap = new LinkedHashMap<Integer, Long>();
        for (int i = 1; i <= parentIdList.size(); ++i) {
            parentIdScaleMap.put(i, parentIdList.get(i - 1));
        }
        OrgDataForDataCompletion orgDataForDataCompletion = new OrgDataForDataCompletion(restOrgData.getOrgId(), restOrgData.getOrgCode(), parentIdScaleMap);
        cache.trySetGroupByTenantId(tenantId, currentKey, orgDataForDataCompletion, false);
        return new UserCenterResponse<OrgDataForDataCompletion>(response.getCode(), response.getMessage(), orgDataForDataCompletion);
    }

    @Override
    public UserCenterResponse<List<MultiScaleUserCompanyData>> getUserOrgAllParentCompanies(Long tenantId, Long userId) {
        UserCenterCacheKey userCenterCacheKey = UserCenterCacheKey.GET_USER_ORG_ALL_PARENT_COMPANIES;
        String currentKey = String.format(userCenterCacheKey.getPattern(), userId);
        UserCenterCache cache = this.cacheService.getUserCenterCache(userCenterCacheKey);
        List cacheValue = (List)cache.getGroupByTenantId(tenantId, currentKey);
        if (cacheValue != null) {
            return new UserCenterResponse<List<MultiScaleUserCompanyData>>("1", "\u6210\u529f", cacheValue);
        }
        String subUrl = String.format("/%s/v2/orgs?userId=%s&status=1", tenantId, userId);
        UserCenterResponse<UserCenterList<OrgDataForMultiScale>> response = this.restTemplateHelper.iterate(this.env, subUrl, 1000, OrgDataForMultiScale.class, tenantId, userId);
        if (!"1".equals(response.getCode()) || response.getResult() == null || CollectionUtils.isEmpty(response.getResult().getContent())) {
            return new UserCenterResponse<Object>(response.getCode(), response.getMessage(), null);
        }
        List<OrgDataForMultiScale> orgList = response.getResult().getContent();
        Map<Long, OrgDataForMultiScale> orgIdToOrgMap = orgList.stream().collect(Collectors.toMap(OrgDataForMultiScale::getOrgId, r -> r));
        List companyOrgList = orgList.stream().filter(r -> r.getOrgType() == 1).collect(Collectors.toList());
        HashSet notExistOrgIdSet = Sets.newHashSet();
        orgList.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getParentIds())).forEach(org -> {
            List<Long> orgIdList = UserCenterJHelper.splitParentIds(org.getParentIds());
            orgIdList.forEach(r -> {
                OrgDataForMultiScale parentOrg = (OrgDataForMultiScale)orgIdToOrgMap.get(r);
                if (parentOrg == null) {
                    notExistOrgIdSet.add(r);
                }
            });
        });
        if (CollectionUtils.isNotEmpty((Collection)notExistOrgIdSet)) {
            Lists.partition((List)Lists.newArrayList((Iterable)notExistOrgIdSet), (int)50).forEach(partition -> {
                String subUrl2 = "/{tenantId}/v2/orgs?orgType=1&status=1&ids={ids}";
                UserCenterResponse<UserCenterList<OrgDataForMultiScale>> response2 = this.restTemplateHelper.iterate(this.env, "/{tenantId}/v2/orgs?orgType=1&status=1&ids={ids}", 100, OrgDataForMultiScale.class, tenantId, partition.stream().map(String::valueOf).collect(Collectors.joining(",")));
                if ("1".equals(response2.getCode()) && response2.getResult() != null && CollectionUtils.isNotEmpty(response2.getResult().getContent())) {
                    companyOrgList.addAll(response2.getResult().getContent());
                }
            });
        }
        List taxNoList = companyOrgList.stream().filter(CommonHelper.distinctByKey(OrgDataForMultiScale::getCompanyId)).map(r -> new MultiScaleUserCompanyData(r.getCompanyId(), r.getTaxNum(), r.getCompanyName())).distinct().collect(Collectors.toList());
        cache.trySetGroupByTenantId(tenantId, currentKey, taxNoList);
        return new UserCenterResponse<List<MultiScaleUserCompanyData>>(response.getCode(), response.getMessage(), taxNoList);
    }

    @Override
    public UserCenterResponse<List<MultiScaleUserCompanyData>> getUserDirectParentCompanies(Long tenantId, Long userId) {
        UserCenterCacheKey userCenterCacheKey = UserCenterCacheKey.GET_USER_DIRECT_PARENT_COMPANIES;
        String currentKey = String.format(userCenterCacheKey.getPattern(), userId);
        UserCenterCache cache = this.cacheService.getUserCenterCache(userCenterCacheKey);
        List cacheValue = (List)cache.getGroupByTenantId(tenantId, currentKey);
        if (cacheValue != null) {
            return new UserCenterResponse<List<MultiScaleUserCompanyData>>("1", "\u6210\u529f", cacheValue);
        }
        String subUrl = "/{tenantId}/v2/orgs?userId={userId}&status=1";
        UserCenterResponse<UserCenterList<OrgDataForMultiScale>> response = this.restTemplateHelper.iterate(this.env, "/{tenantId}/v2/orgs?userId={userId}&status=1", 1000, OrgDataForMultiScale.class, tenantId, userId);
        if (!"1".equals(response.getCode()) || response.getResult() == null || CollectionUtils.isEmpty(response.getResult().getContent())) {
            return new UserCenterResponse<Object>(response.getCode(), response.getMessage(), null);
        }
        List<OrgDataForMultiScale> orgList = response.getResult().getContent();
        Map<Long, OrgDataForMultiScale> orgIdToOrgMap = orgList.stream().collect(Collectors.toMap(OrgDataForMultiScale::getOrgId, r -> r));
        HashSet notExistOrgIdSet = Sets.newHashSet();
        orgList.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getParentIds())).forEach(org -> {
            List<Long> orgIdList = UserCenterJHelper.splitParentIds(org.getParentIds());
            orgIdList.forEach(r -> {
                OrgDataForMultiScale parentOrg = (OrgDataForMultiScale)orgIdToOrgMap.get(r);
                if (parentOrg == null) {
                    notExistOrgIdSet.add(r);
                }
            });
        });
        if (CollectionUtils.isNotEmpty((Collection)notExistOrgIdSet)) {
            Lists.partition((List)Lists.newArrayList((Iterable)notExistOrgIdSet), (int)50).forEach(partition -> {
                String subUrl2 = "/{tenantId}/v2/orgs?orgType=1&status=1&ids={ids}";
                UserCenterResponse<UserCenterList<OrgDataForMultiScale>> response2 = this.restTemplateHelper.iterate(this.env, "/{tenantId}/v2/orgs?orgType=1&status=1&ids={ids}", 100, OrgDataForMultiScale.class, tenantId, partition.stream().map(String::valueOf).collect(Collectors.joining(",")));
                if ("1".equals(response2.getCode()) && response2.getResult() != null && CollectionUtils.isNotEmpty(response2.getResult().getContent())) {
                    orgIdToOrgMap.putAll(response2.getResult().getContent().stream().collect(Collectors.toMap(OrgDataForMultiScale::getOrgId, r -> r, (a, b) -> a)));
                }
            });
        }
        ArrayList companyOrgList = Lists.newArrayList();
        orgList.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getParentIds())).forEach(org -> {
            List<Long> orgIdList = UserCenterJHelper.splitParentIds(org.getParentIds());
            for (int i = orgIdList.size() - 1; i >= 0; --i) {
                Long orgId = orgIdList.get(i);
                OrgDataForMultiScale parentOrg = (OrgDataForMultiScale)orgIdToOrgMap.get(orgId);
                if (parentOrg == null || parentOrg.getOrgType() != 1) continue;
                companyOrgList.add(parentOrg);
                break;
            }
        });
        List taxNoList = companyOrgList.stream().filter(CommonHelper.distinctByKey(OrgDataForMultiScale::getCompanyId)).map(r -> new MultiScaleUserCompanyData(r.getCompanyId(), r.getTaxNum(), r.getCompanyName())).distinct().collect(Collectors.toList());
        cache.trySetGroupByTenantId(tenantId, currentKey, taxNoList);
        return new UserCenterResponse<List<MultiScaleUserCompanyData>>(response.getCode(), response.getMessage(), taxNoList);
    }
}

