/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.auth.plus.pipeline;

import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.extensions.auth.plus.UserCenterOrgJService;
import com.xforceplus.ultraman.extensions.auth.plus.model.OrgDataForDataCompletion;
import com.xforceplus.ultraman.extensions.auth.plus.model.UserCenterResponse;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.FieldOperationHandler;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import java.util.Map;
import java.util.stream.Collectors;

public class MultiOrgIdTransformer
implements FieldOperationHandler {
    private static final String ORG_TREE = "org_tree";
    private static final String TENANT_ID = "tenant_id";
    private final UserCenterOrgJService userCenterOrgJService;
    private final ContextService contextService;
    private final ExecutionConfig executionConfig;

    public MultiOrgIdTransformer(UserCenterOrgJService userCenterOrgJService, ContextService contextService, ExecutionConfig executionConfig) {
        this.userCenterOrgJService = userCenterOrgJService;
        this.contextService = contextService;
        this.executionConfig = executionConfig;
    }

    public String name() {
        return "multi-orgIds";
    }

    public boolean require(Tuple3<IEntityClass, IEntityField, Map<String, Object>> fieldTuple, Object obj) {
        Map inputBody = (Map)fieldTuple._3;
        Object o = inputBody.get(TENANT_ID);
        if (o == null) {
            o = this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTID_KEY);
        }
        if (o == null) {
            return false;
        }
        return this.executionConfig.getOrgTree().contains(Long.parseLong(o.toString())) && obj != null && ((IEntityField)fieldTuple._2()).type() == FieldType.STRINGS && ((IEntityField)fieldTuple._2()).name().equals(ORG_TREE) && !obj.toString().contains(",");
    }

    public boolean require(Tuple2<IEntityClass, IEntityField> fieldTuple, Object obj) {
        return false;
    }

    public Object onCreate(Tuple3<IEntityClass, IEntityField, Map<String, Object>> fieldTuple, Object o) {
        UserCenterResponse<OrgDataForDataCompletion> response;
        Map inputBody = (Map)fieldTuple._3;
        Object tenantId = inputBody.get(TENANT_ID);
        if (tenantId == null) {
            tenantId = this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTID_KEY);
        }
        if ((response = this.userCenterOrgJService.getOrgDataForDataCompletion(Long.parseLong(tenantId.toString()), null, null, Long.parseLong(o.toString()))) != null && response.getResult() != null) {
            OrgDataForDataCompletion result = response.getResult();
            String orgTree = result.getParentIdScaleMap().values().stream().map(Object::toString).collect(Collectors.joining(","));
            return orgTree;
        }
        return o;
    }

    public Object onCreate(Tuple2<IEntityClass, IEntityField> fieldTuple, Object o) {
        return null;
    }

    public Object onUpdate(Tuple3<IEntityClass, IEntityField, Map<String, Object>> fieldTuple, Object o) {
        return this.onCreate(fieldTuple, o);
    }

    public Object onUpdate(Tuple2<IEntityClass, IEntityField> fieldTuple, Object o) {
        return null;
    }
}

