/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.auth.plus.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.vavr.Tuple;
import io.vavr.Tuple3;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.SequenceNode;

public class AuthTemplateProcessor {
    private static final TypeReference<List<Map<String, String>>> LIST_MAP_TYPE = new TypeReference<List<Map<String, String>>>(){};
    private static final TypeReference<Map<String, Object>> MAP_TYPE = new TypeReference<Map<String, Object>>(){};
    private static final TypeReference<Map<String, String>> MAP_STR_TYPE = new TypeReference<Map<String, String>>(){};
    private final String KEY_KEY = "variableKey";
    private final String VAL_KEY = "variableValue";
    private static final String DEFAULT_PATH = "auth-tpl.yaml";
    private Yaml yaml;
    private LoadingCache<Tuple3<String, String, String>, Map<String, Object>> cachedConfig;
    private ObjectMapper mapper;

    public AuthTemplateProcessor(ObjectMapper mapper) {
        this.mapper = mapper;
        this.yaml = new Yaml(new ListConstructor<Template>(Template.class));
        this.cachedConfig = Caffeine.newBuilder().build(env -> {
            List<Template> templates = this.load((String)env._1);
            YamlConfig yamlConfig = new YamlConfig();
            yamlConfig.setTemplates(templates);
            return this.renderTemplate(yamlConfig, (String)env._2, (String)env._3);
        });
    }

    public List<Template> load(String yamlFilePath) {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(yamlFilePath);
        List templates = (List)this.yaml.load(inputStream);
        return templates;
    }

    public Map<String, Object> get(String path, String envCode, String templateCode) {
        return (Map)this.cachedConfig.get((Object)Tuple.of((Object)path, (Object)envCode, (Object)templateCode));
    }

    public Map<String, Object> get(String envCode, String templateCode) {
        return (Map)this.cachedConfig.get((Object)Tuple.of((Object)DEFAULT_PATH, (Object)envCode, (Object)templateCode));
    }

    public Map<String, Object> renderTemplate(YamlConfig config, String envCode, String templateCode) throws JsonProcessingException {
        for (Template template : config.getTemplates()) {
            if (!template.getAuthTemplateCode().equals(templateCode)) continue;
            for (Env env : template.getEnvs()) {
                if (!env.getEnvCode().equals(envCode)) continue;
                Map<String, String> envVariables = this.parseEnvVariables(env.getEnvVariable(), this.mapper);
                return this.renderAuthTemplate(template.getAuthTemplateContent(), envVariables);
            }
        }
        return null;
    }

    private Map<String, String> parseEnvVariables(String envVariableString, ObjectMapper objectMapper) throws JsonProcessingException {
        HashMap<String, String> variablesMap = new HashMap<String, String>();
        envVariableString = envVariableString.replaceAll("'", "\"");
        List maps = (List)objectMapper.readValue(envVariableString, LIST_MAP_TYPE);
        for (Map map : maps) {
            String key = (String)map.get("variableKey");
            if (StringUtils.isEmpty((CharSequence)key)) continue;
            variablesMap.put(key, (String)map.get("variableValue"));
        }
        return variablesMap;
    }

    private Map<String, Object> renderAuthTemplate(String authTemplateContent, Map<String, String> envVariables) {
        for (Map.Entry<String, String> entry : envVariables.entrySet()) {
            String keyPlaceholder = entry.getKey();
            authTemplateContent = authTemplateContent.replace(keyPlaceholder, entry.getValue());
        }
        authTemplateContent = authTemplateContent.replaceAll("'", "\"");
        try {
            return (Map)this.mapper.readValue(authTemplateContent, MAP_TYPE);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Env {
        private String envCode;
        private String envVariable;

        public String getEnvCode() {
            return this.envCode;
        }

        public void setEnvCode(String envCode) {
            this.envCode = envCode;
        }

        public String getEnvVariable() {
            return this.envVariable;
        }

        public void setEnvVariable(String envVariable) {
            this.envVariable = envVariable;
        }
    }

    public static class Template {
        private TemplateVo template;
        private List<Env> envs;

        public String getAuthTemplateCode() {
            return this.template.authTemplateCode;
        }

        public String getAuthTemplateContent() {
            return this.template.authTemplateContent;
        }

        public List<Env> getEnvs() {
            return this.envs;
        }

        public void setEnvs(List<Env> envs) {
            this.envs = envs;
        }

        public TemplateVo getTemplate() {
            return this.template;
        }

        public void setTemplate(TemplateVo template) {
            this.template = template;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Template)) {
                return false;
            }
            Template other = (Template)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TemplateVo this$template = this.getTemplate();
            TemplateVo other$template = other.getTemplate();
            if (this$template == null ? other$template != null : !((Object)this$template).equals(other$template)) {
                return false;
            }
            List<Env> this$envs = this.getEnvs();
            List<Env> other$envs = other.getEnvs();
            return !(this$envs == null ? other$envs != null : !((Object)this$envs).equals(other$envs));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Template;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TemplateVo $template = this.getTemplate();
            result = result * 59 + ($template == null ? 43 : ((Object)$template).hashCode());
            List<Env> $envs = this.getEnvs();
            result = result * 59 + ($envs == null ? 43 : ((Object)$envs).hashCode());
            return result;
        }

        public String toString() {
            return "AuthTemplateProcessor.Template(template=" + this.getTemplate() + ", envs=" + this.getEnvs() + ")";
        }
    }

    public static class TemplateVo {
        private String authTemplateCode;
        private int authTemplateType;
        private String authTemplateContent;

        public String getAuthTemplateCode() {
            return this.authTemplateCode;
        }

        public int getAuthTemplateType() {
            return this.authTemplateType;
        }

        public String getAuthTemplateContent() {
            return this.authTemplateContent;
        }

        public void setAuthTemplateCode(String authTemplateCode) {
            this.authTemplateCode = authTemplateCode;
        }

        public void setAuthTemplateType(int authTemplateType) {
            this.authTemplateType = authTemplateType;
        }

        public void setAuthTemplateContent(String authTemplateContent) {
            this.authTemplateContent = authTemplateContent;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TemplateVo)) {
                return false;
            }
            TemplateVo other = (TemplateVo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAuthTemplateType() != other.getAuthTemplateType()) {
                return false;
            }
            String this$authTemplateCode = this.getAuthTemplateCode();
            String other$authTemplateCode = other.getAuthTemplateCode();
            if (this$authTemplateCode == null ? other$authTemplateCode != null : !this$authTemplateCode.equals(other$authTemplateCode)) {
                return false;
            }
            String this$authTemplateContent = this.getAuthTemplateContent();
            String other$authTemplateContent = other.getAuthTemplateContent();
            return !(this$authTemplateContent == null ? other$authTemplateContent != null : !this$authTemplateContent.equals(other$authTemplateContent));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TemplateVo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAuthTemplateType();
            String $authTemplateCode = this.getAuthTemplateCode();
            result = result * 59 + ($authTemplateCode == null ? 43 : $authTemplateCode.hashCode());
            String $authTemplateContent = this.getAuthTemplateContent();
            result = result * 59 + ($authTemplateContent == null ? 43 : $authTemplateContent.hashCode());
            return result;
        }

        public String toString() {
            return "AuthTemplateProcessor.TemplateVo(authTemplateCode=" + this.getAuthTemplateCode() + ", authTemplateType=" + this.getAuthTemplateType() + ", authTemplateContent=" + this.getAuthTemplateContent() + ")";
        }
    }

    public class ListConstructor<T>
    extends Constructor {
        private final Class<T> clazz;

        public ListConstructor(Class<T> clazz) {
            this.clazz = clazz;
        }

        protected Object constructObject(Node node) {
            if (node instanceof SequenceNode && this.isRootNode(node)) {
                ((SequenceNode)node).setListType(this.clazz);
            }
            return super.constructObject(node);
        }

        private boolean isRootNode(Node node) {
            return node.getStartMark().getIndex() == 0;
        }
    }

    public static class YamlConfig {
        private List<Template> templates;

        public List<Template> getTemplates() {
            return this.templates;
        }

        public void setTemplates(List<Template> templates) {
            this.templates = templates;
        }
    }
}

