/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.auth.plus.util;

import com.xforceplus.tech.common.utils.JsonHelper;
import com.xforceplus.ultraman.extensions.auth.plus.model.UserCenterList;
import com.xforceplus.ultraman.extensions.auth.plus.model.UserCenterResponse;
import com.xforceplus.ultraman.extensions.auth.plus.util.AuthTemplateProcessor;
import com.xforceplus.ultraman.extensions.auth.plus.util.TypeUtil;
import com.xforceplus.ultraman.extensions.auth.plus.util.usercenter.TokenTask;
import com.xforceplus.ultraman.sdk.infra.query.LazyFetchIterator;
import com.xforceplus.ultraman.sdk.infra.utils.IteratorUtils;
import io.vavr.Tuple;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StopWatch;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

public class RestTemplateHelper {
    private final RestTemplate restTemplate;
    private final Logger log = LoggerFactory.getLogger(RestTemplateHelper.class);
    private final AuthTemplateProcessor templateProcessor;
    private TokenTask tokenTask;
    private static final String USER_CENTER_TPL_CODE = "usercenter";

    public RestTemplateHelper(RestTemplate restTemplate, AuthTemplateProcessor templateProcessor) {
        this.restTemplate = restTemplate;
        this.templateProcessor = templateProcessor;
        this.tokenTask = new TokenTask(restTemplate);
    }

    public <T> UserCenterResponse<UserCenterList<T>> iterate(String env, String subUrl, int step, Class<T> clazz, Object ... params) {
        ArrayList responseHolder = new ArrayList();
        Type genericType = TypeUtil.getGenericType(UserCenterResponse.class, TypeUtil.getGenericType(UserCenterList.class, clazz));
        ParameterizedTypeReference parameterizedTypeReference = ParameterizedTypeReference.forType((Type)genericType);
        LazyFetchIterator iterator = new LazyFetchIterator((Object)Tuple.of((Object)0, (Object)step), input -> {
            this.log.debug("Current input {}", input);
            String pageRowStr = String.format("&page=%s&row=%s", input._1, input._2);
            UserCenterResponse fromPaas = (UserCenterResponse)this.getFromPaas(env, subUrl + pageRowStr, parameterizedTypeReference, params);
            if (fromPaas.getCode().equals("1")) {
                List content = ((UserCenterList)fromPaas.getResult()).getContent();
                ((UserCenterList)fromPaas.getResult()).setContent(Collections.emptyList());
                responseHolder.add(fromPaas);
                return content;
            }
            responseHolder.add(fromPaas);
            return Collections.emptyList();
        }, (input, last) -> Tuple.of((Object)((Integer)input._1 + 1), (Object)step), request -> true, response -> response.isEmpty() || response.size() < step, Function.identity());
        List retList = IteratorUtils.toStream((Iterator)iterator).collect(Collectors.toList());
        UserCenterResponse<UserCenterList<T>> container = this.mergeResponse(responseHolder);
        if ("1".equals(container.getCode())) {
            container.getResult().setContent(retList);
        }
        return container;
    }

    private <T> UserCenterResponse<UserCenterList<T>> mergeResponse(List<UserCenterResponse<UserCenterList<T>>> responseHolder) {
        UserCenterResponse container = new UserCenterResponse();
        container.setResult(new UserCenterList());
        Optional<UserCenterResponse> first = responseHolder.stream().filter(x -> !x.getCode().equals("1")).findFirst();
        UserCenterResponse sampleResponse = first.orElseGet(() -> (UserCenterResponse)responseHolder.get(0));
        container.setCode(sampleResponse.getCode());
        container.setMessage(sampleResponse.getMessage());
        return container;
    }

    public <T> T getFromPaas(String env, String subUrl, ParameterizedTypeReference<T> responseClass, Object ... params) {
        Map<String, Object> variables = this.templateProcessor.get(env, USER_CENTER_TPL_CODE);
        if (variables != null) {
            HttpHeaders headers = this.getUserCenterHeader(env);
            String apiHost = variables.get("apiHost").toString();
            String url = apiHost + subUrl;
            StopWatch stopwatch = new StopWatch();
            stopwatch.start(url);
            ResponseEntity exchange = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), responseClass, params);
            stopwatch.stop();
            return (T)exchange.getBody();
        }
        throw new RuntimeException("Configuration Error");
    }

    public <T> UserCenterResponse<T> getFromPaasForUserCenter(String env, String subUrl, ParameterizedTypeReference<UserCenterResponse<T>> responseClass, Object ... params) {
        HttpHeaders headers = this.getUserCenterHeader(env);
        Map<String, Object> variables = this.templateProcessor.get(env, USER_CENTER_TPL_CODE);
        if (variables != null) {
            ResponseEntity exchange;
            String apiHost = variables.get("apiHost").toString();
            String url = apiHost + subUrl;
            StopWatch stopwatch = new StopWatch();
            this.log.info("getFromPaas, url: {}, params: {}", (Object)url, (Object)JsonHelper.toJsonStr((Object)params));
            stopwatch.start(url);
            try {
                exchange = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), responseClass, params);
            }
            catch (HttpStatusCodeException e) {
                this.log.info("getFromPaas, error: {}, {}", (Object)e.getMessage(), (Object)e);
                if (e.getStatusCode().value() == 400) {
                    UserCenterResponse userCenterResponse = JsonHelper.fromJsonStr((String)e.getResponseBodyAsString(), UserCenterResponse.class).orElse(null);
                    return userCenterResponse;
                }
                if (e.getStatusCode().value() == 404) {
                    UserCenterResponse<Object> userCenterResponse = new UserCenterResponse<Object>("0", e.getMessage(), null);
                    return userCenterResponse;
                }
                throw e;
            }
            finally {
                stopwatch.stop();
                this.log.info(stopwatch.prettyPrint());
            }
            this.log.info("getFromPaas, response: {}", (Object)exchange);
            return (UserCenterResponse)exchange.getBody();
        }
        throw new RuntimeException("Configuration Error");
    }

    public <R, T> T postFromPaas(String env, String subUrl, R request, ParameterizedTypeReference<T> responseClass, Object ... params) {
        HttpHeaders headers = this.getUserCenterHeader(env);
        Map<String, Object> variables = this.templateProcessor.get(env, USER_CENTER_TPL_CODE);
        if (variables != null) {
            String apiHost = variables.get("apiHost").toString();
            String url = apiHost + subUrl;
            this.log.info("postFromPaas, url: {}, request: {}", (Object)url, (Object)JsonHelper.toJsonStr(request));
            HttpEntity httpEntity = new HttpEntity(request, (MultiValueMap)headers);
            ResponseEntity exchange = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, responseClass, params);
            this.log.info("postFromPaas, response: {}", (Object)JsonHelper.toJsonStr((Object)exchange));
            return (T)exchange.getBody();
        }
        throw new RuntimeException("Configuration Error");
    }

    public <R, T> T post(String env, String subUrl, R request, Class<T> responseClass, Object ... params) {
        HttpHeaders headers = this.getUserCenterHeader(env);
        Map<String, Object> variables = this.templateProcessor.get(env, USER_CENTER_TPL_CODE);
        if (variables != null) {
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add("Content-Type", "application/json");
            String apiHost = variables.get("apiHost").toString();
            String url = apiHost + subUrl;
            this.log.info("post, url: {}, request: {}", (Object)url, (Object)JsonHelper.toJsonStr(request));
            ResponseEntity exchange = this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity(request, (MultiValueMap)httpHeaders), responseClass, params);
            this.log.info("post, response: {}", (Object)JsonHelper.toJsonStr((Object)exchange));
            return (T)exchange.getBody();
        }
        throw new RuntimeException("Configuration Error");
    }

    private HttpHeaders getUserCenterHeader(String env) {
        Map<String, Object> variables = this.templateProcessor.get(env, USER_CENTER_TPL_CODE);
        if (variables != null) {
            String apiHost = variables.get("apiHost").toString();
            String clientId = variables.get("client").toString();
            String secret = variables.get("secret").toString();
            String token = this.tokenTask.getClientToken(apiHost, clientId, secret);
            HttpHeaders requestHeaders = new HttpHeaders();
            requestHeaders.add("Content-Type", "application/json");
            requestHeaders.add("accept", "application/json");
            requestHeaders.add("x-app-token", token);
            return requestHeaders;
        }
        throw new RuntimeException("Configuration Error");
    }

    public <T> UserCenterResponse<T> getWithExceptionDeal(String methodName, ExceptionSupplier<UserCenterResponse<T>> applyFunc) {
        try {
            return applyFunc.get();
        }
        catch (HttpStatusCodeException e) {
            this.log.error("{} HttpClientErrorException {} {}", new Object[]{methodName, e.getResponseBodyAsString(), e});
            return (UserCenterResponse)JsonHelper.fromJsonStr((String)e.getResponseBodyAsString(), UserCenterResponse.class).orElseThrow(() -> new RuntimeException("Response parse Error from UserCenter"));
        }
        catch (Exception e) {
            this.log.error("{} exception {} {}", new Object[]{methodName, e.getMessage(), e});
            return new UserCenterResponse<Object>("0", e.getMessage(), null);
        }
    }

    @FunctionalInterface
    public static interface ExceptionSupplier<T> {
        public T get() throws Exception;
    }
}

