/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.auth.plus.util.usercenter;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.xforceplus.tech.common.utils.JsonHelper;
import com.xforceplus.ultraman.extensions.auth.plus.model.LoginRequest;
import com.xforceplus.ultraman.extensions.auth.plus.model.LoginResponse;
import io.vavr.Tuple;
import io.vavr.Tuple3;
import java.time.Duration;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

public class TokenTask {
    private static final Logger log = LoggerFactory.getLogger(TokenTask.class);
    private static final String TOKEN_URL = "/client/login";
    private RestTemplate restTemplate;
    private LoadingCache<Tuple3<String, String, String>, String> tokenCache;

    public TokenTask(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
        this.tokenCache = Caffeine.newBuilder().maximumSize(1L).refreshAfterWrite(Duration.ofSeconds(600L)).build(tuple2 -> this.getClientTokenInner((String)tuple2._1, (String)tuple2._2(), (String)tuple2._3));
    }

    private String getClientTokenInner(String url, String clientId, String secret) {
        LoginRequest request = new LoginRequest(clientId, secret);
        String retToken = null;
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "application/json");
        HttpEntity httpRequest = new HttpEntity((Object)request, (MultiValueMap)headers);
        try {
            ResponseEntity loginResponseResponseEntity = this.restTemplate.postForEntity(url.concat(TOKEN_URL), (Object)httpRequest, LoginResponse.class, new Object[0]);
            LoginResponse body = (LoginResponse)loginResponseResponseEntity.getBody();
            if (body != null) {
                retToken = body.getData();
            }
        }
        catch (HttpStatusCodeException httpStatusCodeException) {
            log.error("scheduledGetToken HttpClientErrorException {}", (Object)httpStatusCodeException.getResponseBodyAsString());
            Optional loginResponse = JsonHelper.fromJsonStr((String)httpStatusCodeException.getResponseBodyAsString(), LoginResponse.class);
            if (loginResponse.isPresent()) {
                retToken = ((LoginResponse)loginResponse.get()).getData();
            }
        }
        catch (Throwable throwable) {
            log.error("scheduledGetToken exception", throwable);
            retToken = "";
        }
        return retToken;
    }

    public String getClientToken(String url, String clientId, String secret) {
        return (String)this.tokenCache.get((Object)Tuple.of((Object)url, (Object)clientId, (Object)secret));
    }
}

