package com.xforceplus.ultraman.extensions.cdc.status.config;

import com.xforceplus.ultraman.extensions.cdc.status.StatusService;
import com.xforceplus.ultraman.extensions.cdc.status.impl.DBStatusServiceImpl;
import com.xforceplus.ultraman.extensions.cdc.status.impl.SimpleDBStatusServiceImpl;
import com.xforceplus.ultraman.extensions.cdc.status.listener.EntityChangedListener;
import com.xforceplus.ultraman.extensions.cdc.status.query.WaitForStrategy;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.strategy.QueryStrategy;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

import javax.sql.DataSource;
import java.util.concurrent.ExecutorService;

import static com.xforceplus.ultraman.sdk.infra.utils.ThreadFactoryHelper.buildThreadPool;


@ConditionalOnProperty(value = "xplat.oqsengine.sdk.cdc-status.enabled", matchIfMissing = true)
public class CdcStatusAutoConfiguration {

    @ConditionalOnProperty("xplat.oqsengine.sdk.cdc-status.simple")
    @ConditionalOnMissingBean(StatusService.class)
    @Bean
    public StatusService simpleStatusService(@Qualifier("master") DataSource dataSource, @Value("${xplat.oqsengine.sdk.cdc-status.window:30}") int window, ExecutionConfig executionConfig) {
        ExecutorService executorService = buildThreadPool(10, 1000, "STATUS-SERVICE", false);
        SimpleDBStatusServiceImpl dbStatusService = new SimpleDBStatusServiceImpl(executorService, dataSource, window, executionConfig.isEnableWaitForTimeout());
        dbStatusService.startClean();
        dbStatusService.startNotify();
        return dbStatusService;
    }
    
    @ConditionalOnMissingBean(StatusService.class)
    @Bean
    public StatusService statusService(@Qualifier("master") DataSource dataSource, @Value("${xplat.oqsengine.sdk.cdc-status.window:30}") int window, ExecutionConfig executionConfig) {
        ExecutorService executorService = buildThreadPool(10, 1000, "STATUS-SERVICE", false);
        DBStatusServiceImpl dbStatusService = new DBStatusServiceImpl(executorService, dataSource, window, executionConfig.isEnableWaitForTimeout());
        dbStatusService.startClean();
        dbStatusService.startNotify();
        return dbStatusService;
    }

    @Bean
    public EntityChangedListener entityChangedListener() {
        return new EntityChangedListener();
    }

    @Bean
    public QueryStrategy waitForStrategy(StatusService service){
        return new WaitForStrategy(service);
    }
}
