/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.cdc.status.query;

import com.xforceplus.ultraman.extensions.cdc.status.StatusService;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.values.DateTimeValue;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.DataQueryProvider;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.strategy.QueryStrategy;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.DataContext;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Pair;

public class WaitForStrategy
implements QueryStrategy {
    private StatusService service;
    private ExecutionConfig executionConfig;

    public WaitForStrategy(StatusService service, ExecutionConfig executionConfig) {
        this.service = service;
        this.executionConfig = executionConfig;
    }

    public String name() {
        return "wait_for";
    }

    public int order() {
        return Integer.MAX_VALUE;
    }

    public boolean accept(DataQueryProvider.QueryProviderType type) {
        return type == DataQueryProvider.QueryProviderType.INDEX;
    }

    public void doWithInput(DataQueryProvider dataQueryProvider, String app, IEntityClass entityClass, String profile, RelDataType type, List<RexNode> ops, List<Map.Entry<String, Tuple2<StructKind, Class>>> fields, List<Pair<RexNode, String>> projects, List<Map.Entry<String, RelFieldCollation.Direction>> sort, Long offset, Long fetch, List<String> groupBy, List<AggregateCall> aggs, List<RelHint> hints, RelNode rawTree, DataContext dataContext) {
        Optional<RelHint> waitfor;
        if (hints != null && (waitfor = hints.stream().filter(x -> x.hintName.equalsIgnoreCase("wait_for")).findFirst()).isPresent() && dataQueryProvider.type() == DataQueryProvider.QueryProviderType.INDEX) {
            boolean noWhiteFilter;
            Instant instant = LocalDateTime.now().atZone(DateTimeValue.ZONE_ID).toInstant();
            long currentTime = instant.toEpochMilli();
            List waitForWhiteFilter = this.executionConfig.getWaitForWhiteFilter();
            boolean hitProfile = waitForWhiteFilter != null && !waitForWhiteFilter.isEmpty() && waitForWhiteFilter.contains(profile);
            boolean bl = noWhiteFilter = waitForWhiteFilter == null || waitForWhiteFilter.isEmpty();
            if (noWhiteFilter || hitProfile) {
                this.service.query(Collections.singletonList(Tuple.of((Object)entityClass.id(), (Object)profile)), currentTime);
            }
        }
    }
}

