/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.cdc.status.listener;

import com.xforceplus.ultraman.extensions.cdc.status.StatusService;
import com.xforceplus.ultraman.sdk.core.event.EntityChanged;
import com.xforceplus.ultraman.sdk.infra.logging.LoggingPattern;
import com.xforceplus.ultraman.sdk.infra.logging.LoggingUtils;
import io.vavr.Tuple2;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.event.TransactionalEventListener;

public class EntityChangedListener {
    private static final Logger log = LoggerFactory.getLogger(EntityChangedListener.class);
    @Autowired
    private StatusService statusService;

    @TransactionalEventListener(value={EntityChanged.class})
    public void record(EntityChanged entityChanged) {
        try {
            Map<Tuple2<String, Long>, List<Tuple2>> grouped = entityChanged.getProfiledEntityClass().stream().collect(Collectors.groupingBy(x -> x));
            this.statusService.saveStatus(grouped, entityChanged.getTimeStamp());
        }
        catch (Throwable throwable) {
            LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"RecordChange", (Throwable)throwable);
        }
    }
}

