package com.xforceplus.ultraman.extensions.cdc.status.impl;

import com.xforceplus.ultraman.extensions.cdc.status.StatusService;
import com.xforceplus.ultraman.metadata.cdc.OqsEngineEntity;
import io.vavr.Tuple2;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public abstract class StatusServiceSupport implements StatusService {

  private ExecutorService executorService;

  public StatusServiceSupport(ExecutorService executorService) {
    this.executorService = executorService;
  }

  @Override
  public void saveStatus(Map<Tuple2<String, Long>, ?> grouped, long timestamp) {
    executorService.submit(new Runnable() {
      @Override
      public void run() {
        save(grouped, timestamp);
      }
    });
  }

  @Override
  public void clearStatus(Collection<OqsEngineEntity> oqsEngineEntity) {
    executorService.submit(new Runnable() {
      @Override
      public void run() {
        clear(oqsEngineEntity);
      }
    });
  }

  protected abstract void save(Map<Tuple2<String, Long>, ?> grouped, long timestamp);

  /**
   * clear the status of current oqs-engine Entity
   *
   * @param oqsEngineEntity
   */
  protected abstract void clear(Collection<OqsEngineEntity> oqsEngineEntity);
}
