package com.xforceplus.ultraman.extensions.cdc.status.listener;

import com.xforceplus.ultraman.extensions.cdc.status.StatusService;
import com.xforceplus.ultraman.sdk.core.event.EntityChanged;
import io.vavr.Tuple2;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.event.TransactionalEventListener;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
public class EntityChangedListener {

    @Autowired
    private StatusService statusService;

    @TransactionalEventListener(EntityChanged.class)
    public void record(EntityChanged entityChanged) {
        try {

            Map<Tuple2<String, Long>, List<Tuple2<String, Long>>> grouped = entityChanged
                    .getProfiledEntityClass().stream().collect(Collectors.groupingBy(x -> x));
            statusService.saveStatus(grouped, entityChanged.getTimeStamp());
        } catch (Throwable throwable) {
            log.error(throwable.getMessage());
        }
    }
}
