/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.cdc.status.config;

import com.xforceplus.ultraman.extensions.cdc.status.StatusService;
import com.xforceplus.ultraman.extensions.cdc.status.impl.DBStatusServiceImpl;
import com.xforceplus.ultraman.extensions.cdc.status.listener.EntityChangedListener;
import com.xforceplus.ultraman.extensions.cdc.status.query.WaitForStrategy;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.strategy.QueryStrategy;
import com.xforceplus.ultraman.sdk.infra.utils.ThreadFactoryHelper;
import java.util.concurrent.ExecutorService;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(value={"xplat.oqsengine.sdk.cdc-status.enabled"})
public class CdcStatusAutoConfiguration {
    @ConditionalOnMissingBean(value={StatusService.class})
    @Bean
    public StatusService statusService(@Qualifier(value="master") DataSource dataSource) {
        ExecutorService executorService = ThreadFactoryHelper.buildThreadPool((int)10, (int)1000, (String)"STATUS-SERVICE", (boolean)false);
        DBStatusServiceImpl dbStatusService = new DBStatusServiceImpl(executorService, dataSource);
        dbStatusService.startClean();
        dbStatusService.startNotify();
        return dbStatusService;
    }

    @Bean
    public EntityChangedListener entityChangedListener() {
        return new EntityChangedListener();
    }

    @Bean
    public QueryStrategy waitForStrategy(StatusService service) {
        return new WaitForStrategy(service);
    }
}

