/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extension.changelog.history;

import akka.japi.function.Function;
import akka.stream.ActorAttributes;
import akka.stream.ActorMaterializer;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.OverflowStrategy;
import akka.stream.QueueOfferResult;
import akka.stream.Supervision;
import akka.stream.javadsl.Sink;
import akka.stream.javadsl.Source;
import akka.stream.javadsl.SourceQueueWithComplete;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.xforceplus.ultraman.extension.changelog.history.EventExtractor;
import com.xforceplus.ultraman.extension.changelog.history.domain.RecordOperator;
import com.xforceplus.ultraman.extension.changelog.utils.ChangelogHelper;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.event.EntityCreated;
import com.xforceplus.ultraman.sdk.core.event.EntityDeleted;
import com.xforceplus.ultraman.sdk.core.event.EntityEvent;
import com.xforceplus.ultraman.sdk.core.event.EntityUpdated;
import com.xforceplus.ultraman.sdk.core.utils.MasterStorageHelper;
import com.xforceplus.ultraman.sdk.infra.utils.JacksonDefaultMapper;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.event.TransactionalEventListener;

public class ChangeLogEventListener {
    private static final Logger log = LoggerFactory.getLogger(ChangeLogEventListener.class);
    private static final String INSERT_SQL = "INSERT INTO %s_changelog(cid, id, entityclassl0, entityclassl1, entityclassl2, entityclassl3, entityclassl4, key1, key2, key3, ver, profile, create_time, create_user_id, create_user_name, attr, remark, operation) VALUES\n(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private ActorMaterializer materializer;
    @Qualifier(value="master")
    @Autowired
    private DataSource dataSource;
    @Autowired
    private EntityClassEngine engine;
    private SourceQueueWithComplete<EntityEvent> queue;
    private String appCode;
    @Autowired(required=false)
    private List<EventExtractor> eventExtractors = new ArrayList<EventExtractor>();
    private ForkJoinPool forkJoinPool = new ForkJoinPool(4);

    public ChangeLogEventListener(ActorMaterializer mat, EntityClassEngine engine) {
        this.appCode = engine.appCode();
        this.materializer = mat;
        this.engine = engine;
        this.queue = (SourceQueueWithComplete)Source.queue((int)100000, (OverflowStrategy)OverflowStrategy.backpressure()).groupedWithin(100, Duration.ofSeconds(5L)).map((Function & Serializable)x -> {
            try {
                this.recordChangelog((List<EntityEvent>)x);
            }
            catch (Throwable throwable) {
                log.error("{}", throwable);
            }
            return "";
        }).log("changelog-record").to((Graph)Sink.ignore()).withAttributes(ActorAttributes.withSupervisionStrategy((Function & Serializable)x -> Supervision.resume())).run((Materializer)this.materializer);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setEventExtractors(List<EventExtractor> eventExtractors) {
        this.eventExtractors = eventExtractors;
    }

    private Tuple2<String, String> extractEntityEvent(EntityEvent entityEvent) {
        if (entityEvent instanceof EntityCreated) {
            String code = ((EntityCreated)entityEvent).getCode();
            Map data = ((EntityCreated)entityEvent).getData();
            String s = ChangelogHelper.extractProfile(data);
            return Tuple.of((Object)code, (Object)s);
        }
        if (entityEvent instanceof EntityUpdated) {
            String code = ((EntityUpdated)entityEvent).getCode();
            Map data = ((EntityUpdated)entityEvent).getData();
            String s = ChangelogHelper.extractProfile(data);
            return Tuple.of((Object)code, (Object)s);
        }
        if (entityEvent instanceof EntityDeleted) {
            String code = ((EntityDeleted)entityEvent).getCode();
            Map data = ((EntityDeleted)entityEvent).getData();
            String s = ChangelogHelper.extractProfile(data);
            return Tuple.of((Object)code, (Object)s);
        }
        return Tuple.of((Object)"", (Object)"");
    }

    private void recordChangelog(List<EntityEvent> grouped) {
        Map<Tuple2, List<EntityEvent>> entityGrouped = grouped.stream().collect(Collectors.groupingBy(this::extractEntityEvent));
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(String.format(INSERT_SQL, this.appCode));){
            entityGrouped.entrySet().stream().forEach(entry -> {
                Tuple2 key = (Tuple2)entry.getKey();
                String code = (String)key._1;
                String profile = (String)key._2;
                if (StringUtils.isEmpty((String)code)) {
                    return;
                }
                Optional entityClass = this.engine.loadByCode(code, profile);
                if (entityClass.isPresent()) {
                    List events = (List)entry.getValue();
                    events.forEach(evt -> {
                        try {
                            this.setValue(this.engine.describe((IEntityClass)entityClass.get(), profile), (EntityEvent)evt, profile, statement);
                            statement.addBatch();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    });
                }
            });
            statement.executeBatch();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void setValue(EntityClassGroup entityClassGroup, EntityEvent evt, String profile, PreparedStatement statement) throws SQLException {
        Long id = 0L;
        Optional<EventExtractor> extractor = this.eventExtractors.stream().filter(x -> x.support(evt.getClass())).findFirst();
        if (!extractor.isPresent()) {
            log.warn("Evt {} has no extractor", (Object)evt);
            return;
        }
        EventExtractor eventExtractor = extractor.get();
        statement.setString(1, UUID.randomUUID().toString());
        statement.setLong(2, eventExtractor.extractId(evt));
        RecordOperator operator = eventExtractor.extractUser(evt);
        long currentEntityId = entityClassGroup.getEntityClass().id();
        Collection fatherEntityClass = entityClassGroup.getFatherEntityClass();
        int index = 3;
        for (IEntityClass next : fatherEntityClass) {
            statement.setLong(index, next.id());
            ++index;
        }
        statement.setLong(index, currentEntityId);
        while (index++ < 8) {
            statement.setLong(index, 0L);
        }
        List<String> keys = ChangelogHelper.extractKeys(eventExtractor.getData(evt), entityClassGroup);
        statement.setString(8, keys.get(0));
        statement.setString(9, keys.get(1));
        statement.setString(10, keys.get(2));
        int ver = eventExtractor.extractVer(evt);
        statement.setInt(11, ver);
        statement.setString(12, profile);
        LocalDateTime now = LocalDateTime.now();
        Instant instant = now.atZone(MasterStorageHelper.ZONE_ID).toInstant();
        statement.setLong(13, instant.toEpochMilli());
        statement.setLong(14, operator.getUserId());
        statement.setString(15, operator.getUserName());
        Map<String, Object> body = eventExtractor.extractChangedData(evt);
        try {
            String attr = JacksonDefaultMapper.OBJECT_MAPPER.writeValueAsString(body);
            statement.setString(16, attr);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        statement.setString(17, "");
        statement.setInt(18, eventExtractor.extractType(evt).getType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TransactionalEventListener
    public void recordHistory(EntityEvent evt) {
        try {
            QueueOfferResult join = (QueueOfferResult)this.queue.offer((Object)evt).toCompletableFuture().join();
            if (join != QueueOfferResult.dropped()) return;
        }
        catch (Throwable throwable) {
            log.error("{}", throwable);
        }
    }
}

