/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extension.changelog.history;

import akka.japi.function.Function;
import akka.stream.ActorAttributes;
import akka.stream.ActorMaterializer;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.OverflowStrategy;
import akka.stream.QueueOfferResult;
import akka.stream.Supervision;
import akka.stream.javadsl.Sink;
import akka.stream.javadsl.Source;
import akka.stream.javadsl.SourceQueueWithComplete;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.xforceplus.ultraman.extension.changelog.utils.ChangelogHelper;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.event.EntityDeleted;
import com.xforceplus.ultraman.sdk.core.utils.MasterStorageHelper;
import com.xforceplus.ultraman.sdk.infra.base.cdc.SystemAttachment;
import com.xforceplus.ultraman.sdk.infra.utils.JacksonDefaultMapper;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.event.TransactionalEventListener;

public class HistoryEventListener {
    private static final Logger log = LoggerFactory.getLogger(HistoryEventListener.class);
    private static final String INSERT_SQL = "INSERT INTO %s_history_log(id, entityclassl0, entityclassl1, entityclassl2, entityclassl3, entityclassl4, profile, key1, key2, key3, create_time, create_user_id, create_user_name, attr) VALUES\n(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private ActorMaterializer materializer;
    @Qualifier(value="master")
    @Autowired
    @Lazy
    private DataSource dataSource;
    @Autowired
    private EntityClassEngine engine;
    private SourceQueueWithComplete<EntityDeleted> queue;
    private String appCode;
    private ForkJoinPool forkJoinPool = new ForkJoinPool(4);

    public HistoryEventListener(ActorMaterializer mat) {
        this.materializer = mat;
        this.queue = (SourceQueueWithComplete)Source.queue((int)10000, (OverflowStrategy)OverflowStrategy.backpressure()).groupedWithin(100, Duration.ofSeconds(5L)).map((Function & Serializable)x -> {
            try {
                this.recordDelete((List<EntityDeleted>)x);
            }
            catch (Throwable throwable) {
                log.error("{}", throwable);
            }
            return "";
        }).log("history-record").to((Graph)Sink.ignore()).withAttributes(ActorAttributes.withSupervisionStrategy((Function & Serializable)x -> Supervision.resume())).run((Materializer)this.materializer);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setEngine(EntityClassEngine engine) {
        this.engine = engine;
    }

    private void recordDelete(List<EntityDeleted> grouped) {
        if (this.appCode == null) {
            this.appCode = this.engine.appCode();
        }
        Map<Tuple2, List<EntityDeleted>> entityGrouped = grouped.stream().collect(Collectors.groupingBy(x -> {
            String code = x.getCode();
            Map data = x.getData();
            String s = ChangelogHelper.extractProfile(data);
            return Tuple.of((Object)code, (Object)s);
        }));
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(String.format(INSERT_SQL, this.appCode));){
            entityGrouped.entrySet().stream().forEach(entry -> {
                Tuple2 key = (Tuple2)entry.getKey();
                String code = (String)key._1;
                String profile = (String)key._2;
                Optional entityClass = this.engine.loadByCode(code, profile);
                if (entityClass.isPresent()) {
                    List events = (List)entry.getValue();
                    events.forEach(evt -> {
                        try {
                            this.setValue(this.engine.describe((IEntityClass)entityClass.get(), profile), (EntityDeleted)evt, profile, statement);
                            statement.addBatch();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    });
                }
            });
            statement.executeBatch();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void setValue(EntityClassGroup entityClassGroup, EntityDeleted entityDeleted, String profile, PreparedStatement statement) throws SQLException {
        statement.setLong(1, entityDeleted.getId());
        Map context = entityDeleted.getContext();
        Object attachment = context.get("attachment");
        String delUsername = null;
        long userid = 0L;
        if (attachment instanceof SystemAttachment) {
            delUsername = ((SystemAttachment)attachment).getDelUname();
            userid = ((SystemAttachment)attachment).getDelUId();
        }
        long currentEntityId = entityClassGroup.getEntityClass().id();
        Collection fatherEntityClass = entityClassGroup.getFatherEntityClass();
        int index = 2;
        for (IEntityClass next : fatherEntityClass) {
            statement.setLong(index, next.id());
            ++index;
        }
        statement.setLong(index, currentEntityId);
        while (index++ < 7) {
            statement.setLong(index, 0L);
        }
        statement.setString(7, profile);
        Map body = entityDeleted.getData();
        List<String> keys = ChangelogHelper.extractKeys(body, entityClassGroup);
        statement.setString(8, keys.get(0));
        statement.setString(9, keys.get(1));
        statement.setString(10, keys.get(2));
        LocalDateTime now = LocalDateTime.now();
        Instant instant = now.atZone(MasterStorageHelper.ZONE_ID).toInstant();
        statement.setLong(11, instant.toEpochMilli());
        statement.setLong(12, userid);
        statement.setString(13, delUsername);
        try {
            String attr = JacksonDefaultMapper.OBJECT_MAPPER.writeValueAsString((Object)body);
            statement.setString(14, attr);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TransactionalEventListener
    public void recordHistory(EntityDeleted entityDeleted) {
        try {
            Map data = entityDeleted.getData();
            if (data == null) {
                return;
            }
            QueueOfferResult join = (QueueOfferResult)this.queue.offer((Object)entityDeleted).toCompletableFuture().join();
            if (join != QueueOfferResult.dropped()) return;
        }
        catch (Throwable throwable) {
            log.error("{}", throwable);
        }
    }
}

