package com.xforceplus.ultraman.extension.changelog.history;

public enum EventOperation {

    CREATE(1),

    UPDATE(2),

    DELETE(3);

    private int type;

    EventOperation(int type) {
        this.type = type;
    }

    public int getType() {
        return type;
    }

    public static EventOperation from(int op) {
        switch (op) {
            case 1:
                return CREATE;
            case 2:
                return UPDATE;
            case 3:
                return DELETE;
        }

        return null;
    }
}
