package com.xforceplus.ultraman.extension.changelog.history.impl;

import com.xforceplus.ultraman.extension.changelog.history.EventExtractor;
import com.xforceplus.ultraman.extension.changelog.history.EventOperation;
import com.xforceplus.ultraman.extension.changelog.history.domain.RecordOperator;
import com.xforceplus.ultraman.extension.changelog.utils.ChangelogHelper;
import com.xforceplus.ultraman.sdk.core.event.EntityCreated;

import java.util.Map;
import java.util.Optional;

public class EntityCreatedEventExtractor implements EventExtractor<EntityCreated> {

    @Override
    public long extractId(EntityCreated created) {
        return created.getId();
    }

    @Override
    public String extractProfile(EntityCreated created) {
        String profile = ChangelogHelper.extractProfile(created.getData());
        return profile;
    }

    @Override
    public boolean support(Class clz) {
        return clz == EntityCreated.class;
    }

    @Override
    public Map<String, Object> extractChangedData(EntityCreated created) {
        return created.getData();
    }

    @Override
    public int extractVer(EntityCreated created) {
        return 0;
    }

    @Override
    public EventOperation extractType(EntityCreated created) {
        return EventOperation.CREATE;
    }

    @Override
    public RecordOperator extractUser(EntityCreated evt) {
        Map<String, Object> context = evt.getContext();
        Map<String, Object> data = evt.getData();

        Object userLogin = context.get("USER_DISPLAYNAME");
        Object userId = context.get("ID");

        if(userLogin == null) {
            userLogin = data.get("update_user_name");
        }

        if(userId == null) {
            userId = data.get("update_user_id");
        }

        RecordOperator operator = new RecordOperator();
        operator.setUserId(Optional.ofNullable(userId).map(Object::toString).map(Long::parseLong).orElse(-1L));
        operator.setUserName(Optional.ofNullable(userLogin).map(Object::toString).orElse(""));

        return operator;
    }

    @Override
    public Map<String, Object> getData(EntityCreated evt) {
        return evt.getData();
    }

    @Override
    public Map<String, Object> getContext(EntityCreated evt) {
        return evt.getContext();
    }
}
