/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extension.changelog.config;

import akka.stream.ActorMaterializer;
import com.xforceplus.ultraman.extension.changelog.history.ChangeLogEventListener;
import com.xforceplus.ultraman.extension.changelog.history.EventExtractor;
import com.xforceplus.ultraman.extension.changelog.history.HistoryEventListener;
import com.xforceplus.ultraman.extension.changelog.history.impl.EntityCreatedEventExtractor;
import com.xforceplus.ultraman.extension.changelog.history.impl.EntityDeletedEventExtractor;
import com.xforceplus.ultraman.extension.changelog.history.impl.EntityUpdatedEventExtractor;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ChangeLogAutoConfiguration {
    @ConditionalOnProperty(value={"xplat.oqsengine.sdk.changelog.history.enabled"})
    @Bean
    public HistoryEventListener historyEventListener(ActorMaterializer materializer) {
        return new HistoryEventListener(materializer);
    }

    @ConditionalOnProperty(value={"xplat.oqsengine.sdk.changelog.changelog.enabled"})
    @Bean
    public ChangeLogEventListener changeLogEventListener(ActorMaterializer materializer, EntityClassEngine engine) {
        return new ChangeLogEventListener(materializer, engine);
    }

    @Bean
    public EventExtractor create() {
        return new EntityCreatedEventExtractor();
    }

    @Bean
    public EventExtractor update() {
        return new EntityUpdatedEventExtractor();
    }

    @Bean
    public EventExtractor delete() {
        return new EntityDeletedEventExtractor();
    }
}

