package com.xforceplus.ultraman.extension.changelog.history;

import com.xforceplus.ultraman.extension.changelog.history.domain.RecordOperator;
import com.xforceplus.ultraman.sdk.core.event.EntityEvent;
import com.xforceplus.ultraman.sdk.infra.base.cdc.SystemAttachment;

import java.util.Map;
import java.util.Optional;

public interface EventExtractor<T extends EntityEvent> {

    long extractId(T t);

    String extractProfile(T t);

    boolean support(Class cls);

    Map<String, Object> extractChangedData(T t);

    int extractVer(T t);

    EventOperation extractType(T t);

    default RecordOperator extractUser(T evt) {

        Map<String, Object> context = getContext(evt);
        Map<String, Object> data = getData(evt);

        Object userLogin = context.get("USER_DISPLAYNAME");
        Object userId = context.get("ID");

        if(userLogin == null) {
            userLogin = data.get("update_user_name");
        }

        if(userId == null) {
            userId = data.get("update_user_id");
        }

        if(context != null) {
            Object attachment = context.get("attachment");
            if (attachment instanceof SystemAttachment) {
                String delUsername = null;
                long userid = 0L;
                delUsername = ((SystemAttachment) attachment).getDelUname();
                userid = ((SystemAttachment) attachment).getDelUId();
                if (userLogin == null) {
                    userLogin = delUsername;
                }

                if(userId == null) {
                    userId = userid;
                }
            }
        }

        RecordOperator operator = new RecordOperator();
        operator.setUserId(Optional.ofNullable(userId).map(Object::toString).map(Long::parseLong).orElse(-1L));
        operator.setUserName(Optional.ofNullable(userLogin).map(Object::toString).orElse(""));

        return operator;
    }

    Map<String, Object> getData(T evt);

    Map<String, Object> getContext(T evt);
}
