/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extension.changelog.utils;

import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ChangelogHelper {
    public static String extractProfile(Map<String, Object> data) {
        if (data == null) {
            return "";
        }
        Object tenantCode = data.get("tenant_code");
        if (tenantCode != null) {
            return tenantCode.toString();
        }
        return "";
    }

    public static List<String> extractKeys(Map<String, Object> body, EntityClassGroup entityClassGroup) {
        Collection boIndices = entityClassGroup.getEntityClass().uniqueIndexes();
        ArrayList<String> uniqueKey = new ArrayList<String>(3);
        boIndices.stream().limit(3L).forEach(boIndex -> {
            String fieldIds = boIndex.getFieldIds();
            String[] codes = fieldIds.split(",");
            String key = Arrays.stream(codes).map(code -> Optional.ofNullable(body.get(code)).map(Object::toString).orElse("$NULL$")).collect(Collectors.joining("%%"));
            uniqueKey.add(key);
        });
        if (uniqueKey.size() < 3) {
            int size = uniqueKey.size();
            for (int i = 0; i <= 3 - size; ++i) {
                uniqueKey.add(null);
            }
        }
        return uniqueKey;
    }
}

