/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extentions.cloudevent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.ultraman.extentions.cloudevent.GeneralCloudEvent;
import com.xforceplus.ultraman.sdk.core.event.ExternalEvent;
import com.xforceplus.ultraman.sdk.infra.event.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.bus.ServiceMatcher;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.annotation.Transactional;

public class RemoteEventPublisherWrapper
implements EventPublisher {
    private static final Logger log = LoggerFactory.getLogger(RemoteEventPublisherWrapper.class);
    private ObjectMapper mapper;
    private ApplicationEventPublisher publisher;
    private ServiceMatcher serviceMatcher;

    public RemoteEventPublisherWrapper(ServiceMatcher serviceMatcher, ObjectMapper mapper, ApplicationEventPublisher publisher) {
        this.mapper = mapper;
        this.publisher = publisher;
        this.serviceMatcher = serviceMatcher;
    }

    public void publishEvent(Object object) {
        if (object instanceof ExternalEvent) {
            try {
                String payload = this.mapper.writeValueAsString(object);
                this.publisher.publishEvent((ApplicationEvent)new GeneralCloudEvent(this.serviceMatcher.getBusId(), object.getClass().getName(), payload));
            }
            catch (Throwable e) {
                log.error("{}", e);
            }
        } else {
            try {
                this.publisher.publishEvent(object);
            }
            catch (Throwable e) {
                log.error("{}", e);
            }
        }
    }

    @Transactional
    public void publishTransactionEvent(Object object) {
        try {
            this.publisher.publishEvent(object);
        }
        catch (Throwable throwable) {
            log.error("{}", throwable);
        }
    }
}

