package com.xforceplus.ultraman.extentions.cloudevent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.ultraman.sdk.core.event.ExternalEvent;
import com.xforceplus.ultraman.sdk.infra.event.EventPublisher;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.bus.ServiceMatcher;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.annotation.Transactional;

@Slf4j
public class RemoteEventPublisherWrapper implements EventPublisher {

    private ObjectMapper mapper;

    private ApplicationEventPublisher publisher;

    private ServiceMatcher serviceMatcher;

    public RemoteEventPublisherWrapper(ServiceMatcher serviceMatcher, ObjectMapper mapper, ApplicationEventPublisher publisher) {
        this.mapper = mapper;
        this.publisher = publisher;
        this.serviceMatcher = serviceMatcher;
    }

    @Override
    public void publishEvent(Object object) {
        if (object instanceof ExternalEvent) {
            try {
                String payload = mapper.writeValueAsString(object);
                publisher.publishEvent(new GeneralCloudEvent(serviceMatcher.getBusId(), object.getClass().getName(), payload));
            } catch (Throwable e) {
                log.error("{}", e);
            }
        } else {
            try {
                publisher.publishEvent(object);
            } catch (Throwable e) {
                log.error("{}", e);
            }
        }
    }

    @Override
    public void publishTransactionEvent(Object object) {
        publishEvent(object);
    }
}
