package com.xforceplus.ultraman.extentions.cloudevent.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.ultraman.extentions.cloudevent.GeneralCloudEventListener;
import com.xforceplus.ultraman.extentions.cloudevent.RemoteEventPublisherWrapper;
import com.xforceplus.ultraman.sdk.infra.event.EventPublisher;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.bus.ServiceMatcher;
import org.springframework.cloud.bus.jackson.RemoteApplicationEventScan;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty("xplat.oqsengine.sdk.event.cloud.enabled")
@AutoConfigureBefore(name = "com.xforceplus.ultraman.starter.autoconfigure.EventConfiguration")
@RemoteApplicationEventScan(basePackages = "com.xforceplus.ultraman.extentions.cloudevent")
@Configuration
public class CloudEventAutoConfiguration {

    @Bean
    public EventPublisher remotePublisher(ObjectMapper mapper, ApplicationEventPublisher publisher, ServiceMatcher serviceMatcher) {
        return new RemoteEventPublisherWrapper(serviceMatcher, mapper, publisher);
    }

    @Bean
    public GeneralCloudEventListener generalCloudEventListener(ObjectMapper mapper) {
        return new GeneralCloudEventListener(mapper);
    }
}
