package com.xforceplus.ultraman.extension.cluster.config;


import com.github.alturkovic.lock.Lock;
import com.xforceplus.ultraman.cdc.lock.CDCDestinationLock;
import com.xforceplus.ultraman.extension.cluster.ClusterLockService;
import com.xforceplus.ultraman.extension.cluster.impl.DefaultClusterLockServiceImpl;
import com.xforceplus.ultraman.extension.cluster.impl.DistributeCDCLock;
import com.xforceplus.ultraman.extension.cluster.impl.SimpleClusterNodeServiceImpl;
import com.xforceplus.ultraman.sdk.core.config.CdcConfig;
import com.xforceplus.ultraman.sdk.core.config.ClusterConfig;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import com.xforceplus.ultraman.sdk.infra.base.id.node.NodeIdGenerator;
import com.xforceplus.ultraman.sdk.infra.base.id.node.TimeRandomNodeIdGenerator;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import javax.sql.DataSource;

@ConditionalOnProperty("xplat.oqsengine.sdk.cluster.enabled")
@Configuration
@AutoConfigureAfter(value = {RedisLockAutoConfiguration.class, DataBaseLockAutoConfiguration.class})
@AutoConfigureBefore(name = "com.xforceplus.ultraman.adapter.config.LocalOqsengineAutoConfiguration")
public class ClusterAutoConfiguration {

    @ConditionalOnBean(Lock.class)
    @Bean
    public ClusterLockService lockService() {
        return new DefaultClusterLockServiceImpl();
    }

    @ConditionalOnBean(Lock.class)
    @ConditionalOnProperty("xplat.oqsengine.sdk.cdc.enabled")
    @Bean(destroyMethod = "destroy")
    public CDCDestinationLock destinationLock(CdcConfig cdcConfig) {
        return new DistributeCDCLock(cdcConfig.getLockRetryTime()
                , cdcConfig.getLockPeriod()
                , cdcConfig.getLockExpire());
    }
    
    @Bean
    public NodeIdGenerator simpleNode(@Qualifier("master") DataSource dataSource, ClusterConfig clusterConfig) {
        return new SimpleClusterNodeServiceImpl(new TimeRandomNodeIdGenerator(), dataSource, clusterConfig.getClusterName());
    }
}
