package com.xforceplus.ultraman.extension.cluster.config;

import com.github.alturkovic.lock.Lock;
import com.github.alturkovic.lock.jdbc.impl.SimpleJdbcLock;
import com.github.alturkovic.lock.jdbc.service.JdbcLockSingleKeyService;
import com.github.alturkovic.lock.jdbc.service.SimpleJdbcLockSingleKeyService;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.core.JdbcTemplate;

import java.util.UUID;

@ConditionalOnClass(name = "com.github.alturkovic.lock.jdbc.configuration.JdbcDistributedLockConfiguration")
public class DataBaseLockAutoConfiguration {

    @Bean
    public Lock simpleJdbcLock(final JdbcLockSingleKeyService jdbcLockSingleKeyService) {
        return new SimpleJdbcLock(() -> UUID.randomUUID().toString(), jdbcLockSingleKeyService);
    }

    @Bean
    public JdbcLockSingleKeyService jdbcLockSingleKeyService(@Qualifier("master") final JdbcTemplate jdbcTemplate) {
        return new SimpleJdbcLockSingleKeyService(jdbcTemplate);
    }
}
