package com.xforceplus.ultraman.extension.cluster.config;

import com.github.alturkovic.lock.Lock;
import com.github.alturkovic.lock.jdbc.impl.SimpleJdbcLock;
import com.github.alturkovic.lock.jdbc.service.JdbcLockSingleKeyService;
import com.github.alturkovic.lock.jdbc.service.SimpleJdbcLockSingleKeyService;
import com.github.alturkovic.lock.redis.impl.SimpleRedisLock;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;

import java.util.UUID;

@ConditionalOnClass(name = "com.github.alturkovic.lock.redis.configuration.RedisDistributedLockConfiguration")
@AutoConfigureAfter(RedisAutoConfiguration.class)
public class RedisLockAutoConfiguration {

    @ConditionalOnBean(StringRedisTemplate.class)
    @Bean
    public Lock simpleRedisLock(final StringRedisTemplate stringRedisTemplate) {
        return new SimpleRedisLock(() -> UUID.randomUUID().toString(), stringRedisTemplate);
    }
}
