package com.xforceplus.ultraman.extension.cluster.impl;

import com.github.alturkovic.lock.Lock;
import com.xforceplus.ultraman.extension.cluster.ClusterLockService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;

/**
 * default cluster lock service
 */
@Slf4j
public class DefaultClusterLockServiceImpl implements ClusterLockService {

    @Autowired
    private Lock lock;

    private final static String DISTRIBUTE_STORE = "distributed_lock";

    @Override
    public String acquire(String key, long expire) {
        final String token = lock.acquire(Collections.singletonList(key), DISTRIBUTE_STORE, expire);
        if (StringUtils.isEmpty(token)) {
            log.warn("Cannot get the lock {}", key);
            return null;
        } else {
            return token;
        }
    }

    @Override
    public boolean refresh(String key, String token, long expire) {
        return lock.refresh(Collections.singletonList(key), DISTRIBUTE_STORE, token, expire);
    }

    @Override
    public boolean release(String key, String token) {
        if(StringUtils.isEmpty(token)) {
            return true;
        }

        return lock.release(Collections.singletonList(key), DISTRIBUTE_STORE, token);
    }
}
