package com.xforceplus.ultraman.extension.cluster.impl;

import com.xforceplus.ultraman.cdc.lock.CDCDestinationLock;
import com.xforceplus.ultraman.extension.cluster.ClusterLockService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

/**
 * distribute
 */
public class DistributeCDCLock implements CDCDestinationLock {

    @Autowired
    private ClusterLockService lockService;

    private String key;
    
    private long retryTime = 10L;
    
    private long period = 5L;
    
    private long expire = 10l;

    private AtomicReference<String> token = new AtomicReference<>();

    private ScheduledExecutorService demon = new ScheduledThreadPoolExecutor(2);

    public DistributeCDCLock(long retryTime, long period, long expire) {
        this.retryTime = retryTime;
        this.period = period;
        this.expire = expire;
    }

    public void destroy() {
        demon.shutdown();
        String s = token.get();
        if(s != null) {
            lockService.release(key, s);
        }
        token.set(null);
    }

    @Override
    public void run(String key, Runnable onSuccess, Runnable onFail) {
        this.key = key;
        String acquire = lockService.acquire(key, retryTime * 60 * 1000);
        if (acquire != null) {
            this.token.set(acquire);
            onSuccess.run();
            refresh();
        } else {
            demon.scheduleAtFixedRate(() -> {
                if(token.get() == null) {
                    String getLock = lockService.acquire(key, retryTime * 60 * 1000);
                    if (getLock != null) {
                        this.token.set(getLock);
                        onFail.run();
                        refresh();
                    }
                }
            }, 0, period, TimeUnit.MINUTES);
        }
    }

    private void refresh(){
        demon.scheduleAtFixedRate(() -> {
            lockService.refresh(key, token.get(), expire * 60 * 1000);
        }, 0, 1, TimeUnit.MINUTES);
    }
}
