package com.xforceplus.ultraman.extension.cluster.impl;

import com.xforceplus.ultraman.extension.cluster.ClusterNodeService;
import com.xforceplus.ultraman.sdk.infra.base.id.node.NodeIdGenerator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;

import javax.sql.DataSource;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

/**
 * simple
 */
@Slf4j
public class SimpleClusterNodeServiceImpl implements ClusterNodeService, NodeIdGenerator {

    private JdbcTemplate jdbcTemplate;

    private NodeIdGenerator nodeIdGenerator;

    private String name;

    private static String SQL = "select current_value from node_seq where name = ?";

    private static String UPDATE_SQL = "update node_seq set current_value = ? where name = ? and current_value = ?";

    private static String INIT_SQL = "insert into node_seq(name, current_value) values(?, ?)";

    public SimpleClusterNodeServiceImpl(NodeIdGenerator nodeIdGenerator, DataSource dataSource, String name) {
        this.nodeIdGenerator = nodeIdGenerator;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.name = name;
    }


    private Integer getNodeIdInner() {
        List<Integer> currentNodeId = jdbcTemplate.query(SQL, p -> {
            p.setString(1, name);
        }, (rs, rowNum) -> rs.getInt("current_value"));

        if (!currentNodeId.isEmpty()) {
            Integer nodeId = currentNodeId.get(0);

            if (nodeId + 1 == 1024) {
                nodeId = 0;
            }

            //update 
            Integer finalNodeId = nodeId;
            int update = jdbcTemplate.update(UPDATE_SQL, s -> {
                s.setInt(1, finalNodeId + 1);
                s.setString(2, name);
                s.setInt(3, finalNodeId);
            });

            if (update < 1) {
                return -6;
            } else {
                return nodeId;
            }
        } else {
            try {
                int update = jdbcTemplate.update(INIT_SQL, ps -> {
                    ps.setString(1, name);
                    ps.setInt(2, 2);
                });
                return 1;
            } catch (Throwable throwable) {
                return -6;
            }
        }
    }

    @Override
    public Integer getNodeId() {
        for (int i = 0; i < 10; i++) {
            Integer nodeIdInner = getNodeIdInner();
            if (nodeIdInner == -1) {
                break;
            } else if (nodeIdInner > 0) {
                return nodeIdInner;
            }
        }

        log.warn("Fallback to local nodeIdGenerator");
        return nodeIdGenerator.next();
    }

    @Override
    public Integer next() {
        return getNodeId();
    }
}
