/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extension.cluster.config;

import com.github.alturkovic.lock.Lock;
import com.xforceplus.ultraman.cdc.lock.CDCDestinationLock;
import com.xforceplus.ultraman.extension.cluster.ClusterLockService;
import com.xforceplus.ultraman.extension.cluster.config.DataBaseLockAutoConfiguration;
import com.xforceplus.ultraman.extension.cluster.config.RedisLockAutoConfiguration;
import com.xforceplus.ultraman.extension.cluster.impl.DefaultClusterLockServiceImpl;
import com.xforceplus.ultraman.extension.cluster.impl.DistributeCDCLock;
import com.xforceplus.ultraman.extension.cluster.impl.SimpleClusterNodeServiceImpl;
import com.xforceplus.ultraman.sdk.core.config.CdcConfig;
import com.xforceplus.ultraman.sdk.core.config.ClusterConfig;
import com.xforceplus.ultraman.sdk.infra.base.id.node.NodeIdGenerator;
import com.xforceplus.ultraman.sdk.infra.base.id.node.TimeRandomNodeIdGenerator;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(value={"xplat.oqsengine.sdk.cluster.enabled"})
@Configuration
@AutoConfigureAfter(value={RedisLockAutoConfiguration.class, DataBaseLockAutoConfiguration.class})
@AutoConfigureBefore(name={"com.xforceplus.ultraman.adapter.config.LocalOqsengineAutoConfiguration"})
public class ClusterAutoConfiguration {
    @ConditionalOnBean(value={Lock.class})
    @Bean
    public ClusterLockService lockService() {
        return new DefaultClusterLockServiceImpl();
    }

    @ConditionalOnBean(value={Lock.class})
    @ConditionalOnProperty(value={"xplat.oqsengine.sdk.cdc.enabled"})
    @Bean(destroyMethod="destroy")
    public CDCDestinationLock destinationLock(CdcConfig cdcConfig) {
        return new DistributeCDCLock(cdcConfig.getLockRetryTime(), cdcConfig.getLockPeriod(), cdcConfig.getLockExpire());
    }

    @Bean
    public NodeIdGenerator simpleNode(@Qualifier(value="master") DataSource dataSource, ClusterConfig clusterConfig) {
        return new SimpleClusterNodeServiceImpl((NodeIdGenerator)new TimeRandomNodeIdGenerator(), dataSource, clusterConfig.getClusterName());
    }
}

