/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extension.cluster.impl;

import com.xforceplus.ultraman.extension.cluster.ClusterNodeService;
import com.xforceplus.ultraman.sdk.infra.logging.LoggingPattern;
import com.xforceplus.ultraman.sdk.infra.logging.LoggingUtils;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;

public class DBClusterNodeServiceImpl
implements ClusterNodeService {
    private static final Logger log = LoggerFactory.getLogger(DBClusterNodeServiceImpl.class);
    private static final String FIND_OQS = "SELECT ID FROM NODE_ID where node = ?";
    @Qualifier(value="main")
    @Autowired
    private JdbcTemplate mainJdbcTemplate;

    @Override
    public Integer getNodeId() {
        String name = this.currentNodeName();
        AtomicLong atomicLong = new AtomicLong();
        this.mainJdbcTemplate.query(FIND_OQS, ps -> ps.setString(1, name), rs -> {
            long id = rs.getLong("id");
            atomicLong.set(id);
        });
        return Long.valueOf(atomicLong.get()).intValue();
    }

    private String currentNodeName() {
        String hostName = System.getenv("HOSTNAME");
        if (StringUtils.isEmpty((CharSequence)hostName)) {
            hostName = this.macName();
        }
        return Optional.ofNullable(hostName).orElseGet(() -> UUID.randomUUID().toString());
    }

    private String macName() {
        try {
            InetAddress ipAddress = InetAddress.getLocalHost();
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(ipAddress);
            if (networkInterface != null) {
                byte[] macAddressBytes = networkInterface.getHardwareAddress();
                if (macAddressBytes != null) {
                    StringBuilder macAddressBuilder = new StringBuilder();
                    for (byte b : macAddressBytes) {
                        macAddressBuilder.append(String.format("%02X:", b));
                    }
                    if (macAddressBuilder.length() > 0) {
                        macAddressBuilder.deleteCharAt(macAddressBuilder.length() - 1);
                    }
                    String macAddress = macAddressBuilder.toString();
                    return macAddress;
                }
                return null;
            }
            return null;
        }
        catch (SocketException | UnknownHostException e) {
            LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.GENERAL_UTILS_ERROR, (String)"MacName", (Throwable)e);
            return null;
        }
    }
}

