/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extension.cluster.impl;

import com.xforceplus.ultraman.extension.cluster.ClusterNodeService;
import com.xforceplus.ultraman.sdk.infra.base.id.node.NodeIdGenerator;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class SimpleClusterNodeServiceImpl
implements ClusterNodeService,
NodeIdGenerator {
    private static final Logger log = LoggerFactory.getLogger(SimpleClusterNodeServiceImpl.class);
    private JdbcTemplate jdbcTemplate;
    private NodeIdGenerator nodeIdGenerator;
    private String name;
    private static String SQL = "select current_value from node_seq where name = ?";
    private static String UPDATE_SQL = "update node_seq set current_value = ? where name = ? and current_value = ?";
    private static String INIT_SQL = "insert into node_seq(name, current_value) values(?, ?)";

    public SimpleClusterNodeServiceImpl(NodeIdGenerator nodeIdGenerator, DataSource dataSource, String name) {
        this.nodeIdGenerator = nodeIdGenerator;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.name = name;
    }

    private Integer getNodeIdInner() {
        List currentNodeId = this.jdbcTemplate.query(SQL, p -> p.setString(1, this.name), (rs, rowNum) -> rs.getInt("current_value"));
        if (!currentNodeId.isEmpty()) {
            Integer finalNodeId;
            int update;
            Integer nodeId = (Integer)currentNodeId.get(0);
            if (nodeId + 1 == 1024) {
                nodeId = 0;
            }
            if ((update = this.jdbcTemplate.update(UPDATE_SQL, arg_0 -> this.lambda$getNodeIdInner$2(finalNodeId = nodeId, arg_0))) < 1) {
                return -6;
            }
            return nodeId;
        }
        try {
            int update = this.jdbcTemplate.update(INIT_SQL, ps -> {
                ps.setString(1, this.name);
                ps.setInt(2, 2);
            });
            return 1;
        }
        catch (Throwable throwable) {
            return -6;
        }
    }

    @Override
    public Integer getNodeId() {
        Integer nodeIdInner;
        for (int i = 0; i < 10 && (nodeIdInner = this.getNodeIdInner()) != -1; ++i) {
            if (nodeIdInner <= 0) continue;
            return nodeIdInner;
        }
        log.warn("Fallback to local nodeIdGenerator");
        return this.nodeIdGenerator.next();
    }

    public Integer next() {
        return this.getNodeId();
    }

    private /* synthetic */ void lambda$getNodeIdInner$2(Integer finalNodeId, PreparedStatement s) throws SQLException {
        s.setInt(1, finalNodeId + 1);
        s.setString(2, this.name);
        s.setInt(3, finalNodeId);
    }
}

