/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extension.cluster.config;

import com.github.alturkovic.lock.Lock;
import com.github.alturkovic.lock.redis.impl.SimpleRedisLock;
import java.util.UUID;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.StringRedisTemplate;

@ConditionalOnClass(name={"com.github.alturkovic.lock.redis.configuration.RedisDistributedLockConfiguration"})
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
public class RedisLockAutoConfiguration {
    @ConditionalOnBean(value={StringRedisTemplate.class})
    @Bean
    public Lock simpleRedisLock(StringRedisTemplate stringRedisTemplate) {
        return new SimpleRedisLock(() -> UUID.randomUUID().toString(), stringRedisTemplate);
    }
}

