/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extension.cluster.impl;

import com.github.alturkovic.lock.Lock;
import com.xforceplus.ultraman.extension.cluster.ClusterLockService;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultClusterLockServiceImpl
implements ClusterLockService {
    private static final Logger log = LoggerFactory.getLogger(DefaultClusterLockServiceImpl.class);
    @Autowired
    private Lock lock;
    private static final String DISTRIBUTE_STORE = "distributed_lock";

    @Override
    public String acquire(String key, long expire) {
        String token = this.lock.acquire(Collections.singletonList(key), DISTRIBUTE_STORE, expire);
        if (StringUtils.isEmpty((CharSequence)token)) {
            log.warn("Cannot get the lock {}", (Object)key);
            return null;
        }
        return token;
    }

    @Override
    public boolean refresh(String key, String token, long expire) {
        return this.lock.refresh(Collections.singletonList(key), DISTRIBUTE_STORE, token, expire);
    }

    @Override
    public boolean release(String key, String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            return true;
        }
        return this.lock.release(Collections.singletonList(key), DISTRIBUTE_STORE, token);
    }
}

