/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extension.cluster.impl;

import com.xforceplus.ultraman.cdc.lock.CDCDestinationLock;
import com.xforceplus.ultraman.extension.cluster.ClusterLockService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.factory.annotation.Autowired;

public class DistributeCDCLock
implements CDCDestinationLock {
    @Autowired
    private ClusterLockService lockService;
    private String key;
    private AtomicReference<String> token = new AtomicReference();
    private ScheduledExecutorService demon = new ScheduledThreadPoolExecutor(2);

    public void destroy() {
        this.demon.shutdown();
        String s = this.token.get();
        if (s != null) {
            this.lockService.release(this.key, s);
        }
        this.token.set(null);
    }

    public void run(String key, Runnable onSuccess, Runnable onFail) {
        this.key = key;
        String acquire = this.lockService.acquire(key, 600000L);
        if (acquire != null) {
            this.token.set(acquire);
            onSuccess.run();
            this.refresh();
            return;
        }
        this.demon.scheduleAtFixedRate(() -> {
            String getLock;
            if (this.token.get() == null && (getLock = this.lockService.acquire(key, 600000L)) != null) {
                this.token.set(getLock);
                onFail.run();
                this.refresh();
            }
        }, 0L, 5L, TimeUnit.MINUTES);
    }

    private void refresh() {
        this.demon.scheduleAtFixedRate(() -> this.lockService.refresh(this.key, this.token.get(), 600000L), 0L, 1L, TimeUnit.MINUTES);
    }
}

