/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.messagecenter.config;

import com.xforceplus.ultraman.extensions.messagecenter.config.GatewayUrlSupplier;
import com.xforceplus.ultraman.extensions.messagecenter.config.MessageAppIdSupplier;
import com.xforceplus.ultraman.extensions.messagecenter.config.MessageTokenSupplier;
import com.xforceplus.ultraman.extensions.messagecenter.listener.MessageCenterBulkEventListener;
import com.xforceplus.ultraman.metadata.message.MetadataMessageSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.web.client.RestTemplate;

public class MessageCenterAutoConfiguration {
    @ConditionalOnMissingBean(value={GatewayUrlSupplier.class})
    @Bean
    public GatewayUrlSupplier gatewayUrlSupplier(@Value(value="${xforce.message.gateway.url}") String gateWayUrl) {
        return () -> gateWayUrl;
    }

    @ConditionalOnMissingBean(value={MessageAppIdSupplier.class})
    @Bean
    public MessageAppIdSupplier messageAppIdSupplier(@Value(value="${xforce.message.appId}") String appId) {
        return () -> appId;
    }

    @ConditionalOnBean(value={MessageAppIdSupplier.class, MessageTokenSupplier.class, GatewayUrlSupplier.class, RestTemplate.class})
    @ConditionalOnProperty(value={"xplat.oqsengine.sdk.export.message.enabled"}, matchIfMissing=true)
    @Bean
    public MessageCenterBulkEventListener exportEventListener(MessageTokenSupplier tokenSupplier, MessageAppIdSupplier appIdSupplier, GatewayUrlSupplier gatewayUrlSupplier, @Value(value="${xplat.oqsengine.sdk.export.message.template.content:#{null}}") String content, @Value(value="${xplat.oqsengine.sdk.export.message.template.title:#{null}}") String title, @Value(value="${xplat.oqsengine.sdk.export.message.context-path:}") String contextPath, @Value(value="${xplat.oqsengine.sdk.export.message.ignore-on-sync:true}") boolean ignoreOnSync, RestTemplate restTemplate, MetadataMessageSource messageSource) {
        return new MessageCenterBulkEventListener(tokenSupplier::getToken, appIdSupplier::getStorageAppId, gatewayUrlSupplier::getGatewayUrl, content, title, restTemplate, contextPath, ignoreOnSync, messageSource);
    }
}

